/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.dependency;

import java.util.Objects;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.myire.quill.dependency.ArtifactSpec;
import org.myire.quill.dependency.DependencySpec;
import org.myire.quill.dependency.ModuleDependencySpec;
import org.myire.quill.dependency.ProjectDependencySpec;

public final class Dependencies {
    private Dependencies() {
    }

    public static Project findMatchingProject(ModuleDependencySpec pDependencySpec, Project pStartProject) {
        for (Project aProject = pStartProject; aProject != null; aProject = aProject.getParent()) {
            if (Dependencies.matches(pDependencySpec, aProject)) {
                return aProject;
            }
            for (Project aSubProject : aProject.getSubprojects()) {
                if (!Dependencies.matches(pDependencySpec, aSubProject)) continue;
                return aSubProject;
            }
        }
        return null;
    }

    public static boolean addDependency(Project pProject, ModuleDependencySpec pDependencySpec) {
        Configuration aConfiguration = (Configuration)pProject.getConfigurations().findByName(pDependencySpec.getConfiguration());
        if (aConfiguration == null) {
            return false;
        }
        Dependency aDependency = pProject.getDependencies().create((Object)pDependencySpec.toDependencyNotation());
        Dependencies.copyValues(pDependencySpec, aDependency);
        if (aDependency instanceof ExternalDependency) {
            ((ExternalDependency)aDependency).version(_c -> _c.strictly(pDependencySpec.getVersion()));
            if (aDependency instanceof ExternalModuleDependency) {
                ((ExternalModuleDependency)aDependency).setChanging(pDependencySpec.isChanging());
            }
        }
        aConfiguration.getDependencies().add((Object)aDependency);
        return true;
    }

    public static boolean addDependency(Project pProject, ProjectDependencySpec pDependencySpec) {
        Configuration aConfiguration = (Configuration)pProject.getConfigurations().findByName(pDependencySpec.getConfiguration());
        if (aConfiguration == null) {
            return false;
        }
        Dependency aDependency = pProject.getDependencies().project(pDependencySpec.toMap());
        Dependencies.copyValues(pDependencySpec, aDependency);
        aConfiguration.getDependencies().add((Object)aDependency);
        return true;
    }

    private static boolean matches(ModuleDependencySpec pDependencySpec, Project pProject) {
        return pDependencySpec.matches(Objects.toString(pProject.getGroup(), null), pProject.getName(), Objects.toString(pProject.getVersion(), null));
    }

    private static void copyValues(DependencySpec pDependencySpec, Dependency pDependency) {
        if (pDependency instanceof ModuleDependency) {
            ModuleDependency aModuleDependency = (ModuleDependency)pDependency;
            aModuleDependency.setTransitive(pDependencySpec.isTransitive());
            pDependencySpec.forEachExclusion(e -> aModuleDependency.exclude(e.toMap()));
            pDependencySpec.forEachArtifact(a -> aModuleDependency.addArtifact((DependencyArtifact)Dependencies.toDefaultDependencyArtifact(a)));
        }
    }

    private static DefaultDependencyArtifact toDefaultDependencyArtifact(ArtifactSpec pArtifactSpec) {
        return new DefaultDependencyArtifact(pArtifactSpec.getName(), pArtifactSpec.getType(), pArtifactSpec.getExtension(), pArtifactSpec.getClassifier(), pArtifactSpec.getUrl());
    }
}

