/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.dashboard;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.reporting.Report;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;
import org.myire.quill.common.Projects;
import org.myire.quill.common.Tasks;
import org.myire.quill.dashboard.DashboardLayout;
import org.myire.quill.dashboard.DashboardReports;
import org.myire.quill.dashboard.DashboardReportsImpl;
import org.myire.quill.dashboard.DashboardSection;
import org.myire.quill.dashboard.DashboardSectionFactory;
import org.myire.quill.report.ReportBuilder;
import org.myire.quill.report.ReportingEntity;
import org.myire.quill.report.Reports;

public class DashboardTask
extends DefaultTask
implements ReportingEntity<DashboardReports> {
    static final String TASK_NAME = "reportsDashboard";
    private boolean fVerbose = true;
    private DashboardLayout fLayout;
    private DashboardReports fReports;
    private Map<String, DashboardSection> fSections = new LinkedHashMap<String, DashboardSection>();
    private boolean fHasAddedDefaultSections;
    private DashboardSectionFactory fSectionFactory;

    public Task configure(Closure pClosure) {
        this.maybeAddDefaultSections();
        return super.configure(pClosure);
    }

    @Input
    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean pVerbose) {
        this.fVerbose = pVerbose;
    }

    @Nested
    public DashboardLayout getLayout() {
        return this.fLayout;
    }

    public DashboardLayout layout(Closure pClosure) {
        return (DashboardLayout)ConfigureUtil.configureSelf((Closure)pClosure, (Object)this.fLayout);
    }

    @Override
    @Nested
    public DashboardReports getReports() {
        return this.fReports;
    }

    @Override
    public DashboardReports reports(Closure pClosure) {
        this.fReports.configure(pClosure);
        return this.fReports;
    }

    @Override
    public DashboardReports reports(Action<? super DashboardReports> pAction) {
        pAction.execute((Object)this.fReports);
        return this.fReports;
    }

    @Input
    public List<DashboardSectionSpec> getInputSections() {
        this.maybeAddDefaultSections();
        return this.fSections.values().stream().map(DashboardSectionSpec::new).collect(Collectors.toList());
    }

    @Internal
    public Map<String, DashboardSection> getSections() {
        this.maybeAddDefaultSections();
        return this.fSections;
    }

    public void addSection(String pName, Report pReport, Object pXslFile) {
        this.addSection(pName, pReport, null, pXslFile);
    }

    public void addSection(String pName, Report pReport, Report pDetailedReport, Object pXslFile) {
        File aXslFile = this.getProject().file(pXslFile);
        this.fSections.put(pName, new DashboardSection(this.getProject(), pName, pReport, pDetailedReport, aXslFile));
    }

    public boolean addBuiltInSection(Task pTask) {
        DashboardSection aSection = this.fSectionFactory.create(pTask);
        if (aSection != null) {
            this.fSections.put(aSection.getName(), aSection);
            return true;
        }
        return false;
    }

    public DashboardSection removeSection(String pName) {
        return this.fSections.remove(pName);
    }

    @TaskAction
    public void createReport() {
        if (Reports.isRequired((Report)this.fReports.getHtml())) {
            try {
                ReportBuilder aReportBuilder = new ReportBuilder(Reports.getOutputLocation((Report)this.fReports.getHtml()));
                this.fLayout.write(aReportBuilder, this.fSections.values(), this.findChildProjectDashboards());
                aReportBuilder.close();
                if (this.fVerbose) {
                    this.getLogger().lifecycle("Created reports dashboard {}", new Object[]{aReportBuilder.getDestination().getAbsolutePath()});
                }
            }
            catch (IOException ioe) {
                this.getLogger().error("Could not create reports dashboard", (Throwable)ioe);
            }
        }
    }

    void init() {
        this.fSectionFactory = new DashboardSectionFactory(this.getProject());
        this.fLayout = new DashboardLayout(this.getProject());
        this.fReports = new DashboardReportsImpl(this);
        Tasks.outputFile((Task)this, () -> Reports.getOutputLocation((Report)this.getReports().getHtml()));
        this.onlyIf(ignore -> Reports.isRequired((Report)this.getReports().getHtml()));
    }

    private void maybeAddDefaultSections() {
        if (this.fHasAddedDefaultSections) {
            return;
        }
        for (DashboardSection aSection : this.fSectionFactory.createAvailableDefaultSections()) {
            this.getLogger().debug("Adding default reports dashboard section {}", (Object)aSection.getName());
            this.fSections.put(aSection.getName(), aSection);
        }
        this.fHasAddedDefaultSections = true;
    }

    private Map<String, String> findChildProjectDashboards() {
        Collection aChildTasks = this.getProject().getChildProjects().values().stream().map(p -> Projects.getTask(p, TASK_NAME, DashboardTask.class)).filter(Objects::nonNull).collect(Collectors.toList());
        if (aChildTasks.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> aChildProjectsDashboards = new HashMap<String, String>();
        Path aBasePath = Reports.getOutputLocation((Report)this.getReports().getHtml()).toPath().getParent();
        for (DashboardTask aChildTask : aChildTasks) {
            Path aChildReportPath = Reports.getOutputLocation((Report)aChildTask.getReports().getHtml()).toPath();
            String aRelativePath = aBasePath.relativize(aChildReportPath).toString();
            aChildProjectsDashboards.put(aChildTask.getProject().getName(), aRelativePath);
        }
        return aChildProjectsDashboards;
    }

    private static class DashboardSectionFile
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String fAbsolutePath;
        private final boolean fExists;
        private final long fLastModified;

        DashboardSectionFile(File pFile) {
            this.fAbsolutePath = pFile.getAbsolutePath();
            this.fExists = pFile.exists();
            this.fLastModified = pFile.lastModified();
        }

        public boolean equals(Object pObject) {
            if (pObject == this) {
                return true;
            }
            if (!(pObject instanceof DashboardSectionFile)) {
                return false;
            }
            DashboardSectionFile aOther = (DashboardSectionFile)pObject;
            return Objects.equals(this.fAbsolutePath, aOther.fAbsolutePath) && this.fExists == aOther.fExists && this.fLastModified == aOther.fLastModified;
        }

        public int hashCode() {
            return Objects.hash(this.fAbsolutePath, this.fExists, this.fLastModified);
        }
    }

    private static class DashboardSectionSpec
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String fName;
        private final DashboardSectionFile fInputReportFile;
        private final DashboardSectionFile fDetailedReportFile;
        private final DashboardSectionFile fXslFile;

        DashboardSectionSpec(DashboardSection pSection) {
            this.fName = pSection.getName();
            this.fInputReportFile = DashboardSectionSpec.toDashboardSectionFile(DashboardSectionSpec.getReportFileSpec(pSection.getReport()));
            this.fDetailedReportFile = DashboardSectionSpec.toDashboardSectionFile(DashboardSectionSpec.getReportFileSpec(pSection.getDetailedReport()));
            this.fXslFile = DashboardSectionSpec.toDashboardSectionFile(pSection.getXslFile());
        }

        public boolean equals(Object pObject) {
            if (pObject == this) {
                return true;
            }
            if (!(pObject instanceof DashboardSectionSpec)) {
                return false;
            }
            DashboardSectionSpec aOther = (DashboardSectionSpec)pObject;
            return this.fName.equals(aOther.fName) && Objects.equals(this.fInputReportFile, aOther.fInputReportFile) && Objects.equals(this.fDetailedReportFile, aOther.fDetailedReportFile) && Objects.equals(this.fXslFile, aOther.fXslFile);
        }

        public int hashCode() {
            return Objects.hash(this.fName, this.fInputReportFile, this.fDetailedReportFile, this.fXslFile);
        }

        private static File getReportFileSpec(Report pReport) {
            return Reports.isRequired(pReport) ? Reports.getOutputLocation(pReport) : null;
        }

        private static DashboardSectionFile toDashboardSectionFile(File pFile) {
            return pFile != null ? new DashboardSectionFile(pFile) : null;
        }
    }
}

