/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.scent;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.myire.quill.common.ExternalToolLoader;
import org.myire.quill.common.Projects;
import org.myire.quill.report.ReportingEntity;
import org.myire.quill.report.TransformingReport;
import org.myire.quill.scent.ScentReports;
import org.myire.quill.scent.ScentReportsImpl;
import org.myire.quill.scent.ScentRunner;

public class ScentTask
extends SourceTask
implements ReportingEntity<ScentReports> {
    private static final String DEFAULT_TOOL_VERSION = "2.2";
    private static final String IMPLEMENTATION_PACKAGE = "org.myire.quill.scent.impl.";
    private static final String IMPLEMENTATION_CLASS = "ScentRunnerImpl";
    private String fToolVersion;
    private String fSourceEncoding;
    private FileCollection fScentClasspath;
    private ScentReportsImpl fReports;

    @Input
    public String getToolVersion() {
        return this.fToolVersion != null ? this.fToolVersion : DEFAULT_TOOL_VERSION;
    }

    public void setToolVersion(String pToolVersion) {
        this.fToolVersion = pToolVersion;
    }

    @Input
    @Optional
    public String getSourceEncoding() {
        return this.fSourceEncoding;
    }

    public void setSourceEncoding(String pSourceEncoding) {
        this.fSourceEncoding = pSourceEncoding;
    }

    @InputFiles
    public FileCollection getScentClasspath() {
        return this.fScentClasspath;
    }

    public void setScentClasspath(FileCollection pScentClasspath) {
        this.fScentClasspath = pScentClasspath;
    }

    @InputFiles
    @SkipWhenEmpty
    public FileTree getSource() {
        SourceSet aMainSourceSet;
        FileTree aSource = super.getSource();
        if ((aSource == null || aSource.isEmpty()) && (aMainSourceSet = Projects.getSourceSet(this.getProject(), "main")) != null) {
            aSource = aMainSourceSet.getAllJava();
            this.setSource(aSource);
        }
        return aSource;
    }

    @Override
    @Nested
    public ScentReports getReports() {
        return this.fReports;
    }

    @Override
    public ScentReports reports(Closure pClosure) {
        this.fReports.configure(pClosure);
        return this.fReports;
    }

    @Override
    public ScentReports reports(Action<? super ScentReports> pAction) {
        pAction.execute((Object)this.fReports);
        return this.fReports;
    }

    @TaskAction
    public void run() {
        SingleFileReport aXmlReport = this.fReports.getXml();
        if (aXmlReport.isEnabled()) {
            this.collectMetricsAsXml(aXmlReport.getDestination());
            TransformingReport aHtmlReport = this.fReports.getHtml();
            if (aHtmlReport.isEnabled()) {
                aHtmlReport.transform();
            }
        } else {
            this.getLogger().info("Scent XML report is disabled, metrics will not be collected");
        }
    }

    void setupReports() {
        this.fReports = new ScentReportsImpl(this);
        this.onlyIf(ignore -> this.getReports().getXml().isEnabled());
        this.fReports.setInputsAndOutputs((Task)this);
    }

    private void collectMetricsAsXml(File pXmlFile) {
        try {
            Projects.ensureParentExists(pXmlFile);
            Charset aCharset = this.fSourceEncoding != null ? Charset.forName(this.fSourceEncoding) : Charset.defaultCharset();
            this.getLogger().debug("Collecting scent metrics using charset '{}' into file '{}'", (Object)aCharset.name(), (Object)pXmlFile);
            this.loadScentRunner().collectMetricsAsXml(this.getSource().getFiles(), aCharset, pXmlFile);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.getLogger().error("Could not create an instance of '{}{}'", new Object[]{IMPLEMENTATION_PACKAGE, IMPLEMENTATION_CLASS, e});
        }
        catch (IOException ioe) {
            this.getLogger().error("Could not write the metrics report to '{}'", (Object)pXmlFile, (Object)ioe);
        }
    }

    private ScentRunner loadScentRunner() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ExternalToolLoader<ScentRunner> aLoader = new ExternalToolLoader<ScentRunner>(ScentRunner.class, IMPLEMENTATION_PACKAGE, IMPLEMENTATION_CLASS, this::getScentClasspath);
        return aLoader.createToolProxy();
    }
}

