/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.repository;

import java.util.Collection;
import java.util.Objects;
import org.myire.quill.common.GradlePrettyPrinter;
import org.myire.quill.common.PrettyPrintable;
import org.myire.quill.repository.CredentialsSpec;

public abstract class RepositorySpec
implements PrettyPrintable {
    private static final String CLOSURE_REPOSITORIES = "repositories";
    private static final String ATTRIBUTE_URL = "url";
    private final String fName;
    private final String fUrl;
    private CredentialsSpec fCredentials;

    protected RepositorySpec(String pName, String pUrl) {
        this.fName = Objects.requireNonNull(pName);
        this.fUrl = pUrl;
    }

    public String getName() {
        return this.fName;
    }

    public String getUrl() {
        return this.fUrl;
    }

    public CredentialsSpec getCredentials() {
        return this.fCredentials;
    }

    public void setCredentials(String pUserName, String pPassword) {
        this.fCredentials = pUserName != null ? new CredentialsSpec(pUserName, pPassword) : null;
    }

    public static void prettyPrintRepositories(GradlePrettyPrinter pPrinter, Collection<? extends RepositorySpec> pRepositories) {
        if (pRepositories.size() > 0) {
            pPrinter.printClosure(CLOSURE_REPOSITORIES, p -> pRepositories.forEach(r -> r.prettyPrint((GradlePrettyPrinter)p)));
        }
    }

    protected void printClosureBody(GradlePrettyPrinter pPrinter) {
        pPrinter.printMethodCall(ATTRIBUTE_URL, this.fUrl, true, false);
        CredentialsSpec aCredentials = this.getCredentials();
        if (aCredentials != null) {
            aCredentials.prettyPrint(pPrinter);
        }
    }
}

