/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.report;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Project;
import org.myire.quill.common.Projects;
import org.myire.quill.report.AbstractTransformingReport;

public class FileTransformingReport
extends AbstractTransformingReport {
    private final Closure<File> fInput;

    public FileTransformingReport(Project pProject, String pName, String pDisplayName, String pXslResource, Closure<File> pInput) {
        super(pProject, pName, pDisplayName, pXslResource, (Closure<File>)new DefaultDestination(pProject, pInput, pName));
        this.fInput = pInput;
    }

    @Override
    protected File getInputFile() {
        return (File)this.fInput.call();
    }

    private static class DefaultDestination
    extends Closure<File> {
        private final Project fProject;
        private final Closure<File> fInput;
        private final String fDefaultBaseName;

        DefaultDestination(Project pProject, Closure<File> pInput, String pDefaultBaseName) {
            super(null);
            this.fProject = pProject;
            this.fInput = pInput;
            this.fDefaultBaseName = pDefaultBaseName;
        }

        public File doCall(Object pValue) {
            File aInputFile = (File)this.fInput.call();
            if (aInputFile != null) {
                return new File(aInputFile.getParentFile(), aInputFile.getName().replace(".xml", ".html"));
            }
            return Projects.createReportDirectorySpec(this.fProject, this.fDefaultBaseName + ".html");
        }
    }
}

