/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.report;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DocTypeFilterStream
extends FilterInputStream {
    private static final byte[] cDocTypeStartBytes = "<!DOCTYPE".getBytes();
    private static final byte END_OF_DECLARATION = 62;
    private static final byte SPACE = 32;
    private final byte[] fBuffer = new byte[8192];
    private int fPos;
    private int fLength;
    private boolean fEndOfStreamReached;
    private boolean fIsFiltering;
    private int fPartialMatchLength;

    public DocTypeFilterStream(InputStream pInputStream) {
        super(pInputStream);
    }

    @Override
    public int read() throws IOException {
        while (!this.hasBufferedData() && !this.fEndOfStreamReached) {
            this.load();
        }
        return this.fEndOfStreamReached ? -1 : this.fBuffer[this.fPos++];
    }

    @Override
    public int read(byte[] pBuffer) throws IOException {
        return this.read(pBuffer, 0, pBuffer.length);
    }

    @Override
    public int read(byte[] pBuffer, int pOffset, int pLength) throws IOException {
        int aNumAvailableBytes;
        if (!this.hasBufferedData()) {
            this.load();
        }
        if ((aNumAvailableBytes = this.numBytesInBuffer()) > 0) {
            int aNumBytesToRead = aNumAvailableBytes;
            if (aNumBytesToRead > pLength) {
                aNumBytesToRead = pLength;
            }
            System.arraycopy(this.fBuffer, this.fPos, pBuffer, pOffset, aNumBytesToRead);
            this.fPos += aNumBytesToRead;
            return aNumBytesToRead;
        }
        if (this.fEndOfStreamReached) {
            return -1;
        }
        return 0;
    }

    @Override
    public long skip(long pNumBytes) {
        long aNumBytesToSkip = this.numBytesInBuffer();
        if (aNumBytesToSkip > pNumBytes) {
            aNumBytesToSkip = pNumBytes;
        }
        this.fPos = (int)((long)this.fPos + aNumBytesToSkip);
        return aNumBytesToSkip;
    }

    @Override
    public int available() throws IOException {
        return this.numBytesInBuffer() + super.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private boolean hasBufferedData() {
        return this.fPos < this.fLength;
    }

    private int numBytesInBuffer() {
        return this.fLength - this.fPos;
    }

    private void load() throws IOException {
        int aRemaining = this.numBytesInBuffer();
        System.arraycopy(this.fBuffer, this.fPos, this.fBuffer, 0, aRemaining);
        this.fPos = 0;
        this.fLength = aRemaining;
        this.restorePartialMatch();
        if (!this.fEndOfStreamReached) {
            int aNumReadBytes = super.read(this.fBuffer, this.fLength, this.fBuffer.length - this.fLength);
            if (aNumReadBytes > 0) {
                this.fLength += aNumReadBytes;
            } else if (aNumReadBytes < 0) {
                this.fEndOfStreamReached = true;
            }
            this.filter();
            if (this.fEndOfStreamReached) {
                this.restorePartialMatch();
            }
        }
    }

    private void restorePartialMatch() {
        if (this.fPartialMatchLength > 0 && this.fBuffer.length - this.fLength >= this.fPartialMatchLength) {
            System.arraycopy(cDocTypeStartBytes, 0, this.fBuffer, this.fLength, this.fPartialMatchLength);
            this.fLength += this.fPartialMatchLength;
            this.fPartialMatchLength = 0;
        }
    }

    private void filter() {
        int aFilterPos = this.fPos;
        while (aFilterPos < this.fLength) {
            while (this.fIsFiltering && aFilterPos < this.fLength) {
                if (this.fBuffer[aFilterPos] == 62) {
                    this.fIsFiltering = false;
                }
                this.fBuffer[aFilterPos++] = 32;
            }
            int aDoctypeStartPos = this.findDoctypeStart();
            if (aDoctypeStartPos < 0) break;
            int aMatchLength = this.fLength - aDoctypeStartPos;
            if (aMatchLength >= cDocTypeStartBytes.length) {
                this.fIsFiltering = true;
                aFilterPos = aDoctypeStartPos;
                continue;
            }
            this.fLength = aDoctypeStartPos;
            this.fPartialMatchLength = aMatchLength;
            aFilterPos = this.fLength;
        }
    }

    private int findDoctypeStart() {
        int aBufferPos = this.fPos;
        int aPatternPos = 0;
        while (aBufferPos < this.fLength && aPatternPos < cDocTypeStartBytes.length) {
            if (this.fBuffer[aBufferPos] == cDocTypeStartBytes[aPatternPos]) {
                ++aBufferPos;
                ++aPatternPos;
                continue;
            }
            if (aPatternPos == 0) {
                ++aBufferPos;
                continue;
            }
            aPatternPos = 0;
        }
        if (aPatternPos > 0) {
            return aBufferPos - aPatternPos;
        }
        return -1;
    }
}

