/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.report;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.myire.quill.report.DefaultSingleFileReport;
import org.myire.quill.report.FormatChoiceReport;

public class DefaultFormatChoiceReport
extends DefaultSingleFileReport
implements FormatChoiceReport {
    private final Set<String> fLegalFormats = new HashSet<String>();
    private String fFormat;

    public DefaultFormatChoiceReport(Project pProject, String pName, String pDisplayName, String pDefaultFormat, Closure<File> pDefaultDestination) {
        super(pProject, pName, pDisplayName, pDefaultDestination);
        this.fLegalFormats.add(pDefaultFormat);
        this.fFormat = pDefaultFormat;
    }

    public void addLegalFormats(String ... pFormats) {
        Collections.addAll(this.fLegalFormats, pFormats);
    }

    @Override
    public String getFormat() {
        return this.fFormat;
    }

    @Override
    public void setFormat(String pFormat) {
        if (this.fLegalFormats.contains(pFormat)) {
            this.fFormat = pFormat;
        } else {
            this.getProjectLogger().warn("Report '{}' does not support format '{}', keeping '{}'", new Object[]{this.getName(), pFormat, this.fFormat});
        }
    }
}

