/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.maven.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.settings.Mirror;

class MirrorMatcher {
    private static final String WILDCARD = "*";
    private static final String EXTERNAL_WILDCARD = "external:*";
    private final Set<String> fPatterns = new HashSet<String>();
    private final boolean fHasWildcard;
    private final boolean fHasExternalWildcard;

    MirrorMatcher(Collection<Mirror> pMirrors) {
        boolean aHasWildcard = false;
        boolean aHasExternalWildcard = false;
        for (Mirror aMirror : pMirrors) {
            StringTokenizer aTokenizer = new StringTokenizer(aMirror.getMirrorOf(), ",");
            while (aTokenizer.hasMoreTokens()) {
                String aPattern = aTokenizer.nextToken().trim();
                if (WILDCARD.equals(aPattern)) {
                    aHasWildcard = true;
                    continue;
                }
                if (EXTERNAL_WILDCARD.equals(aPattern)) {
                    aHasExternalWildcard = true;
                    continue;
                }
                if (aPattern.isEmpty()) continue;
                this.fPatterns.add(aPattern);
            }
        }
        this.fHasWildcard = aHasWildcard;
        this.fHasExternalWildcard = aHasExternalWildcard;
    }

    boolean matches(ArtifactRepository pRepository) {
        if (this.fPatterns.contains('!' + pRepository.getId())) {
            return false;
        }
        if (this.fHasWildcard) {
            return true;
        }
        if (this.fHasExternalWildcard && MirrorMatcher.isExternalRepository(pRepository)) {
            return true;
        }
        return this.fPatterns.contains(pRepository.getId());
    }

    private static boolean isExternalRepository(ArtifactRepository pArtifactRepository) {
        return !"file".equals(pArtifactRepository.getProtocol()) && !pArtifactRepository.getUrl().contains("localhost") && !pArtifactRepository.getUrl().contains("127.0.0.1");
    }
}

