/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.myire.quill.common.ExternalToolLoader;
import org.myire.quill.common.ProjectAware;
import org.myire.quill.common.Projects;
import org.myire.quill.dependency.Dependencies;
import org.myire.quill.dependency.DependencySpec;
import org.myire.quill.dependency.ModuleDependencySpec;
import org.myire.quill.dependency.ProjectDependencySpec;
import org.myire.quill.maven.EffectivePomLoader;
import org.myire.quill.maven.MavenImportExtension;
import org.myire.quill.repository.MavenRepositorySpec;
import org.myire.quill.repository.RepositorySpec;

class PomImporter
extends ProjectAware {
    private static final String IMPLEMENTATION_PACKAGE = "org.myire.quill.maven.impl.";
    private static final String IMPLEMENTATION_CLASS = "EffectivePomLoaderImpl";
    private static final Map<File, PomImporter> cCache = new HashMap<File, PomImporter>();
    private final File fPomFile;
    private final MavenImportExtension fExtension;
    private EffectivePomLoader fPomLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PomImporter getInstance(Project pProject, File pPomFile) {
        Map<File, PomImporter> map = cCache;
        synchronized (map) {
            return cCache.computeIfAbsent(pPomFile, f -> new PomImporter(pProject, (File)f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearInstanceCache() {
        Map<File, PomImporter> map = cCache;
        synchronized (map) {
            cCache.clear();
        }
    }

    private PomImporter(Project pProject, File pPomFile) {
        super(pProject);
        this.fPomFile = Objects.requireNonNull(pPomFile);
        this.fExtension = Projects.getExtension(pProject, "mavenImport", MavenImportExtension.class);
    }

    File getPomFile() {
        return this.fPomFile;
    }

    Collection<DependencySpec> importDependencies() {
        Collection<ModuleDependencySpec> aDependencies = this.maybeCreatePomLoader().getDependencies();
        return aDependencies.stream().map(this::convertDependency).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
    }

    Collection<RepositorySpec> importRepositories() {
        return this.maybeCreatePomLoader().getRepositories();
    }

    RepositorySpec importLocalRepository() {
        return this.maybeCreatePomLoader().getLocalRepository();
    }

    String getGroupId() {
        return this.maybeCreatePomLoader().getGroupId();
    }

    String getVersionString() {
        return this.maybeCreatePomLoader().getVersion();
    }

    private EffectivePomLoader maybeCreatePomLoader() {
        if (this.fPomLoader == null) {
            this.fPomLoader = this.createEffectivePomLoader();
            this.fPomLoader.init(this.fPomFile, this.fExtension != null ? this.fExtension.getSettingsFile() : null);
        }
        return this.fPomLoader;
    }

    private DependencySpec convertDependency(ModuleDependencySpec pDependency) {
        String aConfiguration = this.scopeToConfiguration(pDependency.getConfiguration());
        if (aConfiguration != null) {
            Project aProject = Dependencies.findMatchingProject(pDependency, this.getProject());
            if (aProject != null) {
                ProjectDependencySpec aProjectDependency = new ProjectDependencySpec(aConfiguration, aProject.getPath());
                aProjectDependency.setValues(pDependency);
                return aProjectDependency;
            }
            pDependency.setConfiguration(aConfiguration);
            return pDependency;
        }
        this.getProjectLogger().info("Scope '{}' has no mapping, skipping dependency '{}'", (Object)pDependency.getConfiguration(), (Object)pDependency.toDependencyNotation());
        return null;
    }

    private String scopeToConfiguration(String pScope) {
        Map<String, String> aMapping;
        Map<String, String> map = aMapping = this.fExtension != null ? this.fExtension.getScopeToConfiguration() : null;
        if (aMapping == null) {
            return pScope;
        }
        String aConfiguration = aMapping.get(pScope);
        if (aConfiguration != null) {
            return aConfiguration;
        }
        if (aMapping.containsKey(pScope)) {
            return null;
        }
        return pScope;
    }

    private EffectivePomLoader createEffectivePomLoader() {
        try {
            ExternalToolLoader<EffectivePomLoader> aLoader = new ExternalToolLoader<EffectivePomLoader>(EffectivePomLoader.class, IMPLEMENTATION_PACKAGE, IMPLEMENTATION_CLASS, this.fExtension::getMavenClassPath);
            return aLoader.createToolProxy();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.getProjectLogger().error("Could not create an instance of '{}.{}'", new Object[]{IMPLEMENTATION_PACKAGE, IMPLEMENTATION_CLASS, e});
            return EmptyEffectivePomLoader.INSTANCE;
        }
    }

    private static class EmptyEffectivePomLoader
    implements EffectivePomLoader {
        static final EmptyEffectivePomLoader INSTANCE = new EmptyEffectivePomLoader();

        private EmptyEffectivePomLoader() {
        }

        @Override
        public void init(File pPomFile, File pSettingsFile) {
        }

        @Override
        public Collection<ModuleDependencySpec> getDependencies() {
            return Collections.emptyList();
        }

        @Override
        public Collection<RepositorySpec> getRepositories() {
            return Collections.emptyList();
        }

        @Override
        public RepositorySpec getLocalRepository() {
            return new MavenRepositorySpec("local", "");
        }

        @Override
        public String getGroupId() {
            return "";
        }

        @Override
        public String getArtifactId() {
            return "";
        }

        @Override
        public String getVersion() {
            return "";
        }
    }
}

