/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.jol;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.myire.quill.common.Projects;
import org.myire.quill.jol.JolTask;

public class JolPlugin
implements Plugin<Project> {
    private static final String TASK_NAME = "jol";
    private static final String CONFIGURATION_NAME = "jol";
    private static final String JOL_GROUP_ARTIFACT_ID = "org.openjdk.jol:jol-core";
    private Project fProject;
    private JolTask fTask;
    private Configuration fConfiguration;

    public void apply(Project pProject) {
        this.fProject = pProject;
        pProject.getPlugins().apply(JavaPlugin.class);
        this.fConfiguration = this.createConfiguration();
        this.fTask = this.createTask();
    }

    private Configuration createConfiguration() {
        Configuration aConfiguration = (Configuration)this.fProject.getConfigurations().maybeCreate("jol");
        aConfiguration.setVisible(false);
        aConfiguration.setTransitive(true);
        aConfiguration.setDescription("The Jol classes used by the Jol task");
        aConfiguration.getIncoming().beforeResolve(_ignore -> this.setConfigurationDependencies());
        return aConfiguration;
    }

    private void setConfigurationDependencies() {
        if (this.fConfiguration.getDependencies().isEmpty()) {
            String aID = "org.openjdk.jol:jol-core:" + this.fTask.getToolVersion();
            this.fConfiguration.getDependencies().add((Object)this.fProject.getDependencies().create((Object)aID));
        }
    }

    private JolTask createTask() {
        JolTask aTask = (JolTask)this.fProject.getTasks().create("jol", JolTask.class);
        aTask.setDescription("Runs Jol to create an object layout report");
        aTask.setToolClassPath((FileCollection)this.fConfiguration);
        aTask.setupReports();
        this.fProject.afterEvaluate(this::finalizeTaskConfiguration);
        Task aBuildTask = Projects.getTask(this.fProject, "build", Task.class);
        if (aBuildTask != null) {
            aBuildTask.dependsOn(new Object[]{aTask});
        }
        return aTask;
    }

    private void finalizeTaskConfiguration(Project pProject) {
        this.fTask.maybeConfigureDefaultClasses();
    }
}

