/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.dependency;

import java.util.Objects;
import org.myire.quill.common.GradlePrettyPrinter;
import org.myire.quill.common.PrettyPrintable;

public class ArtifactSpec
implements PrettyPrintable {
    private static final String CLOSURE_ARTIFACT = "artifact";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_EXTENSION = "extension";
    private static final String ATTRIBUTE_CLASSIFIER = "classifier";
    private static final String ATTRIBUTE_URL = "url";
    private final String fName;
    private final String fType;
    private final String fExtension;
    private final String fClassifier;
    private final String fUrl;

    public ArtifactSpec(String pName, String pType, String pExtension, String pClassifier, String pUrl) {
        this.fName = Objects.requireNonNull(pName);
        this.fType = pType;
        this.fExtension = pExtension;
        this.fClassifier = pClassifier;
        this.fUrl = pUrl;
    }

    public String getName() {
        return this.fName;
    }

    public String getType() {
        return this.fType;
    }

    public String getExtension() {
        return this.fExtension;
    }

    public String getClassifier() {
        return this.fClassifier;
    }

    public String getUrl() {
        return this.fUrl;
    }

    @Override
    public void prettyPrint(GradlePrettyPrinter pPrinter) {
        pPrinter.printClosure(CLOSURE_ARTIFACT, this::printAttributes);
    }

    private void printAttributes(GradlePrettyPrinter pPrinter) {
        pPrinter.printAttribute(ATTRIBUTE_NAME, this.fName);
        pPrinter.printAttribute(ATTRIBUTE_TYPE, this.fType);
        pPrinter.printAttribute(ATTRIBUTE_EXTENSION, this.fExtension);
        pPrinter.printAttribute(ATTRIBUTE_CLASSIFIER, this.fClassifier);
        pPrinter.printAttribute(ATTRIBUTE_URL, this.fUrl);
    }
}

