/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.dashboard;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.myire.quill.dashboard.DashboardSection;
import org.myire.quill.report.ReportBuilder;

public class DashboardLayout {
    private static final String HTML_RESOURCE_REPORT_CSS = "/org/myire/quill/rsrc/report/report.css";
    private static final String XSL_RESOURCE_CHILD_PROJECTS = "/org/myire/quill/rsrc/report/child_projects.xsl";
    private static final Supplier<String> EMPTY_STRING_SUPPLIER = () -> "";
    private final Project fProject;
    private final String fDefaultTitle;
    private int fNumColumns = 2;
    private Supplier<String> fHeadlineHtmlCode = this::defaultHeadlineHtmlCode;
    private Supplier<String> fSectionsStartHtmlCode = () -> "<table width=\"100%\">";
    private Supplier<String> fSectionsEndHtmlCode = () -> "</table>";
    private Supplier<String> fRowStartHtmlCode = () -> "<tr>";
    private Supplier<String> fRowEndHtmlCode = () -> "</tr>";
    private Supplier<String> fCellStartHtmlCode = this::defaultCellStartHtmlCode;
    private Supplier<String> fCellEndHtmlCode = () -> "</td>";
    private File fHeaderHtmlFile;
    private File fFooterHtmlFile;

    DashboardLayout(Project pProject) {
        this.fProject = pProject;
        this.fDefaultTitle = pProject.getName() + " build reports summary";
    }

    @InputFile
    @Optional
    public File getHeaderHtmlFile() {
        return this.fHeaderHtmlFile;
    }

    public void setHeaderHtmlFile(Object pFile) {
        this.fHeaderHtmlFile = pFile != null ? this.fProject.file(pFile) : null;
    }

    @InputFile
    @Optional
    public File getFooterHtmlFile() {
        return this.fFooterHtmlFile;
    }

    public void setFooterHtmlFile(Object pFile) {
        this.fFooterHtmlFile = pFile != null ? this.fProject.file(pFile) : null;
    }

    @Input
    public String getHeadlineHtmlCode() {
        return this.fHeadlineHtmlCode.get();
    }

    public void setHeadlineHtmlCode(Object pCode) {
        this.fHeadlineHtmlCode = DashboardLayout.asStringSupplier(pCode);
    }

    @Input
    public String getSectionsStartHtmlCode() {
        return this.fSectionsStartHtmlCode.get();
    }

    public void setSectionsStartHtmlCode(Object pCode) {
        this.fSectionsStartHtmlCode = DashboardLayout.asStringSupplier(pCode);
    }

    @Input
    public String getSectionsEndHtmlCode() {
        return this.fSectionsEndHtmlCode.get();
    }

    public void setSectionsEndHtmlCode(Object pCode) {
        this.fSectionsEndHtmlCode = DashboardLayout.asStringSupplier(pCode);
    }

    @Input
    public String getRowStartHtmlCode() {
        return this.fRowStartHtmlCode.get();
    }

    public void setRowStartHtmlCode(Object pCode) {
        this.fRowStartHtmlCode = DashboardLayout.asStringSupplier(pCode);
    }

    @Input
    public String getRowEndHtmlCode() {
        return this.fRowEndHtmlCode.get();
    }

    public void setRowEndHtmlCode(Object pCode) {
        this.fRowEndHtmlCode = DashboardLayout.asStringSupplier(pCode);
    }

    @Input
    public String getCellStartHtmlCode() {
        return this.fCellStartHtmlCode.get();
    }

    public void setCellStartHtmlCode(Object pCode) {
        this.fCellStartHtmlCode = DashboardLayout.asStringSupplier(pCode);
    }

    @Input
    public String getCellEndHtmlCode() {
        return this.fCellEndHtmlCode.get();
    }

    public void setCellEndHtmlCode(Object pCode) {
        this.fCellEndHtmlCode = DashboardLayout.asStringSupplier(pCode);
    }

    @Input
    public int getNumColumns() {
        return this.fNumColumns;
    }

    public void setNumColumns(int pNumColumns) {
        this.fNumColumns = pNumColumns;
    }

    void write(ReportBuilder pReportBuilder, Collection<DashboardSection> pSections, Map<String, String> pChildProjectDashboards) {
        if (this.fHeaderHtmlFile != null) {
            pReportBuilder.copy(this.fHeaderHtmlFile);
        } else {
            this.writeDefaultHeader(pReportBuilder);
        }
        this.writeHeadline(pReportBuilder);
        this.writeSectionsMatrix(pReportBuilder, pSections);
        this.writeChildProjectsLinks(pReportBuilder, pChildProjectDashboards);
        if (this.fFooterHtmlFile != null) {
            pReportBuilder.copy(this.fFooterHtmlFile);
        } else {
            this.writeDefaultFooter(pReportBuilder);
        }
    }

    private void writeDefaultHeader(ReportBuilder pBuilder) {
        pBuilder.write("<html><head>");
        pBuilder.write("<title>");
        pBuilder.write(this.fDefaultTitle);
        pBuilder.write("</title>");
        pBuilder.write("<style type=\"text/css\">");
        pBuilder.copy(HTML_RESOURCE_REPORT_CSS);
        pBuilder.write("</style></head><body>");
    }

    private void writeDefaultFooter(ReportBuilder pBuilder) {
        pBuilder.write("</body></html>");
    }

    private void writeHeadline(ReportBuilder pBuilder) {
        pBuilder.write(this.fHeadlineHtmlCode.get());
    }

    private void writeSectionsMatrix(ReportBuilder pBuilder, Collection<DashboardSection> pSections) {
        String aRowStartHtmlCode = this.fRowStartHtmlCode.get();
        String aRowEndHtmlCode = this.fRowEndHtmlCode.get();
        String aCellStartHtmlCode = this.fCellStartHtmlCode.get();
        String aCellEndHtmlCode = this.fCellEndHtmlCode.get();
        pBuilder.write(this.fSectionsStartHtmlCode.get());
        int aIndex = 0;
        int aLastSection = pSections.size() - 1;
        for (DashboardSection aSection : pSections) {
            int aColumnPos = aIndex % this.fNumColumns;
            if (aColumnPos == 0) {
                pBuilder.write(aRowStartHtmlCode);
            }
            pBuilder.write(aCellStartHtmlCode);
            aSection.writeTo(pBuilder);
            pBuilder.write(aCellEndHtmlCode);
            if (aColumnPos == this.fNumColumns - 1 || aIndex == aLastSection) {
                pBuilder.write(aRowEndHtmlCode);
            }
            ++aIndex;
        }
        pBuilder.write(this.fSectionsEndHtmlCode.get());
    }

    private void writeChildProjectsLinks(ReportBuilder pBuilder, Map<String, String> pChildProjectDashboards) {
        String aXml = this.createChildProjectsXml(pChildProjectDashboards);
        if (aXml != null) {
            pBuilder.transform(aXml, XSL_RESOURCE_CHILD_PROJECTS, null);
        }
    }

    private String createChildProjectsXml(Map<String, String> pChildProjectDashboards) {
        if (pChildProjectDashboards.isEmpty()) {
            return null;
        }
        StringBuilder aBuffer = new StringBuilder();
        aBuffer.append("<child-projects>");
        for (Map.Entry<String, String> aEntry : pChildProjectDashboards.entrySet()) {
            aBuffer.append("<child-project name=\"").append(aEntry.getKey()).append("\" report=\"").append(aEntry.getValue()).append("\"/>");
        }
        aBuffer.append("</child-projects>");
        return aBuffer.toString();
    }

    private String defaultHeadlineHtmlCode() {
        return "<p class=\"headline\">" + this.fDefaultTitle + "</p>";
    }

    private String defaultCellStartHtmlCode() {
        int aWidthPercent = 100 / this.fNumColumns;
        return "<td width=\"" + aWidthPercent + "%\" valign=\"top\">";
    }

    private static Supplier<String> asStringSupplier(Object pObject) {
        if (pObject instanceof Supplier) {
            return () -> ((Supplier)pObject).get().toString();
        }
        if (pObject instanceof Closure) {
            return () -> ((Closure)pObject).call().toString();
        }
        if (pObject != null) {
            return pObject::toString;
        }
        return EMPTY_STRING_SUPPLIER;
    }
}

