/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.cpd;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.reporting.Report;
import org.gradle.util.ConfigureUtil;
import org.myire.quill.cpd.CpdReports;
import org.myire.quill.cpd.CpdTask;
import org.myire.quill.report.DefaultFormatChoiceReport;
import org.myire.quill.report.FormatChoiceReport;
import org.myire.quill.report.FormatChoiceReportTransformingReport;
import org.myire.quill.report.TransformingReport;

public class CpdReportsImpl
implements CpdReports {
    private static final String PRIMARY_REPORT_NAME = "cpdPrimary";
    private static final String HTML_REPORT_NAME = "cpdHtml";
    private static final String BUILTIN_CPD_XSL = "/org/myire/quill/rsrc/report/cpd/cpd.xsl";
    private final DefaultFormatChoiceReport fPrimaryReport;
    private final TransformingReport fHtmlReport;

    CpdReportsImpl(CpdTask pTask) {
        this.fPrimaryReport = new DefaultFormatChoiceReport(pTask.getProject(), PRIMARY_REPORT_NAME, "CPD primary report", "xml", (Closure<File>)new DefaultPrimaryReportDestination(pTask));
        this.fPrimaryReport.addLegalFormats("csv", "text", "csv_with_linecount_per_file", "vs");
        this.fHtmlReport = new FormatChoiceReportTransformingReport(pTask.getProject(), HTML_REPORT_NAME, "CPD HTML report", this.fPrimaryReport, BUILTIN_CPD_XSL);
        this.fPrimaryReport.setEnabled(true);
        this.fHtmlReport.setEnabled(true);
    }

    @Override
    public FormatChoiceReport getPrimary() {
        return this.fPrimaryReport;
    }

    @Override
    public TransformingReport getHtml() {
        return this.fHtmlReport;
    }

    @Override
    public Report getReportByName(String pReportName) {
        if (PRIMARY_REPORT_NAME.equalsIgnoreCase(pReportName)) {
            return this.fPrimaryReport;
        }
        if (HTML_REPORT_NAME.equalsIgnoreCase(pReportName)) {
            return this.fHtmlReport;
        }
        return null;
    }

    public CpdReports configure(Closure pClosure) {
        ConfigureUtil.configureSelf((Closure)pClosure, (Object)this);
        return this;
    }

    private static class DefaultPrimaryReportDestination
    extends Closure<File> {
        private final CpdTask fTask;

        DefaultPrimaryReportDestination(CpdTask pTask) {
            super(null);
            this.fTask = pTask;
        }

        public File doCall(Object pValue) {
            return this.fTask.defaultPrimaryDestination();
        }
    }
}

