/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.common;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logging;

public class ExternalToolProxyClassLoader
extends URLClassLoader {
    private final Predicate<String> fProxyClassPredicate;
    private final Supplier<FileCollection> fExternalToolLocations;
    private URLClassLoader fExternalToolClassLoader;

    ExternalToolProxyClassLoader(Supplier<FileCollection> pExternalToolLocations, Predicate<String> pProxyClassPredicate, ClassLoader pParent) {
        super(ExternalToolProxyClassLoader.getUrls(pParent), pParent);
        this.fExternalToolLocations = Objects.requireNonNull(pExternalToolLocations);
        this.fProxyClassPredicate = Objects.requireNonNull(pProxyClassPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String pName, boolean pResolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(pName);
        synchronized (object) {
            try {
                if (this.fExternalToolClassLoader == null) {
                    this.fExternalToolClassLoader = this.createExternalToolClassLoader();
                }
                return this.fExternalToolClassLoader.loadClass(pName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.fProxyClassPredicate.test(pName)) {
                    Class<?> aClass = this.findLoadedClass(pName);
                    if (aClass == null) {
                        aClass = this.findClass(pName);
                    }
                    if (pResolve) {
                        this.resolveClass(aClass);
                    }
                    return aClass;
                }
                return super.loadClass(pName, pResolve);
            }
        }
    }

    private URLClassLoader createExternalToolClassLoader() {
        return new URLClassLoader(ExternalToolProxyClassLoader.createUrls(this.fExternalToolLocations.get().getFiles()), ExternalToolProxyClassLoader.getPlatformClassLoader());
    }

    private static ClassLoader getPlatformClassLoader() {
        try {
            MethodHandle aMethodHandle = MethodHandles.lookup().findStatic(ClassLoader.class, "getPlatformClassLoader", MethodType.methodType(ClassLoader.class));
            return aMethodHandle.invokeExact();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static URL[] createUrls(Collection<File> pFiles) {
        return (URL[])pFiles.stream().map(ExternalToolProxyClassLoader::fileToUrl).filter(Objects::nonNull).toArray(URL[]::new);
    }

    private static URL[] getUrls(ClassLoader pClassLoader) {
        if (pClassLoader instanceof URLClassLoader) {
            return ((URLClassLoader)pClassLoader).getURLs();
        }
        return new URL[0];
    }

    private static URL fileToUrl(File pFile) {
        try {
            return pFile.toURI().toURL();
        }
        catch (MalformedURLException mue) {
            Logging.getLogger(ExternalToolProxyClassLoader.class).debug("Cannot convert file " + pFile + " to an URL, not adding to class loader");
            return null;
        }
    }
}

