/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.jol.impl;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.myire.quill.jol.JolParameters;
import org.myire.quill.jol.JolResult;
import org.myire.quill.jol.JolRunner;
import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.datamodel.X86_32_DataModel;
import org.openjdk.jol.datamodel.X86_64_COOPS_DataModel;
import org.openjdk.jol.datamodel.X86_64_DataModel;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.info.FieldLayout;
import org.openjdk.jol.layouters.CurrentLayouter;
import org.openjdk.jol.layouters.HotSpotLayouter;
import org.openjdk.jol.layouters.Layouter;
import org.openjdk.jol.layouters.RawLayouter;
import org.openjdk.jol.util.ClassUtils;

public class JolRunnerImpl
implements JolRunner {
    private String fToolVersion = "unknown";
    private final Logger fLogger = Logging.getLogger(JolRunnerImpl.class);

    @Override
    public void init(String pToolVersion) {
        this.fToolVersion = pToolVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JolResult analyze(Collection<String> pClasses, JolParameters pParameters) {
        ByteArrayOutputStream aJolOutputStream = new ByteArrayOutputStream(1024);
        PrintStream aJolSystemOut = new PrintStream(aJolOutputStream);
        PrintStream aOriginalSystemOut = System.out;
        System.setOut(aJolSystemOut);
        try {
            Layouter aLayouter = JolRunnerImpl.createLayouter(pParameters);
            JolResult aResult = new JolResult(this.fToolVersion, aLayouter.toString());
            for (String aClassName : pClasses) {
                Class<?> aClass = this.loadClass(aClassName);
                if (aClass == null) continue;
                ClassLayout aClassLayout = aLayouter.layout(ClassData.parseClass(aClass));
                aResult.add(JolRunnerImpl.toResult(aClass, aClassLayout));
            }
            JolResult jolResult = aResult;
            return jolResult;
        }
        finally {
            System.setOut(aOriginalSystemOut);
            aJolSystemOut.close();
            String aJolOutput = aJolOutputStream.toString();
            if (!aJolOutput.isEmpty()) {
                this.fLogger.debug("Jol output: {}", (Object)aJolOutput);
            }
        }
    }

    private Class<?> loadClass(String pClassName) {
        try {
            return ClassUtils.loadClass((String)pClassName);
        }
        catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
            this.fLogger.error("Could not load class {} for layout analysis", (Object)pClassName, (Object)cnfe);
            return null;
        }
    }

    private static JolResult.ClassLayout toResult(Class<?> pClass, ClassLayout pClassLayout) {
        Collection aFields = pClassLayout.fields().stream().map(JolRunnerImpl::toResult).collect(Collectors.toList());
        return new JolResult.ClassLayout(pClass.getSimpleName(), JolRunnerImpl.getPackageName(pClass), JolRunnerImpl.getEnclosingClassName(pClass), pClassLayout.headerSize(), pClassLayout.instanceSize(), aFields);
    }

    private static JolResult.FieldLayout toResult(FieldLayout pFieldLayout) {
        return new JolResult.FieldLayout(pFieldLayout.name(), pFieldLayout.typeClass(), pFieldLayout.offset(), pFieldLayout.size());
    }

    private static Layouter createLayouter(JolParameters pParameters) {
        switch (pParameters.fLayout) {
            case RAW: {
                return new RawLayouter(JolRunnerImpl.createDataModel(pParameters));
            }
            case HOTSPOT: {
                return new HotSpotLayouter(JolRunnerImpl.createDataModel(pParameters));
            }
            case CURRENT: {
                return new CurrentLayouter();
            }
        }
        throw new IllegalArgumentException("Invalid layout parameter: " + (Object)((Object)pParameters.fLayout));
    }

    private static DataModel createDataModel(JolParameters pParameters) {
        switch (pParameters.fDataModel) {
            case x86_32: {
                return new X86_32_DataModel(pParameters.fAlignment);
            }
            case x86_64: {
                return new X86_64_DataModel(pParameters.fAlignment);
            }
            case x86_64_COMPRESSED: {
                return new X86_64_COOPS_DataModel(pParameters.fAlignment);
            }
        }
        throw new IllegalArgumentException("Invalid data model parameter: " + (Object)((Object)pParameters.fDataModel));
    }

    private static String getPackageName(Class<?> pClass) {
        Package aPackage = pClass.getPackage();
        return aPackage != null ? aPackage.getName() : "";
    }

    private static String getEnclosingClassName(Class<?> pClass) {
        int aNumClassNameChars = 0;
        ArrayList aClassHierarchy = new ArrayList();
        for (Class<?> aEnclosingClass = pClass.getEnclosingClass(); aEnclosingClass != null; aEnclosingClass = aEnclosingClass.getEnclosingClass()) {
            aNumClassNameChars += aEnclosingClass.getSimpleName().length();
            aClassHierarchy.add(aEnclosingClass);
        }
        if (aClassHierarchy.isEmpty()) {
            return null;
        }
        if (aClassHierarchy.size() == 1) {
            return ((Class)aClassHierarchy.get(0)).getSimpleName();
        }
        StringBuilder aBuffer = new StringBuilder(aNumClassNameChars + aClassHierarchy.size());
        for (int i = aClassHierarchy.size() - 1; i > 0; --i) {
            aBuffer.append(((Class)aClassHierarchy.get(i)).getSimpleName()).append('.');
        }
        aBuffer.append(((Class)aClassHierarchy.get(0)).getSimpleName());
        return aBuffer.toString();
    }
}

