/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.jol;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.ConfigureUtil;
import org.myire.quill.common.ExternalToolLoader;
import org.myire.quill.common.Projects;
import org.myire.quill.jol.JolParameters;
import org.myire.quill.jol.JolReports;
import org.myire.quill.jol.JolReportsImpl;
import org.myire.quill.jol.JolResult;
import org.myire.quill.jol.JolRunner;
import org.myire.quill.jol.JolXmlReportWriter;
import org.myire.quill.report.ReportingEntity;
import org.myire.quill.report.TransformingReport;

public class JolTask
extends DefaultTask
implements ReportingEntity<JolReports> {
    private static final String DEFAULT_TOOL_VERSION = "0.10";
    private static final String IMPLEMENTATION_PACKAGE = "org.myire.quill.jol.impl.";
    private static final String IMPLEMENTATION_CLASS = "JolRunnerImpl";
    private JolParameters.Layout fLayout;
    private JolParameters.DataModel fDataModel;
    private int fAlignment = 8;
    private String fToolVersion;
    private Collection<String> fClasses = new ArrayList<String>();
    private FileCollection fAnalysisClassPath;
    private FileCollection fToolClassPath;
    private JolReportsImpl fReports;
    private final Collection<ClassesDirectory> fClassesDirectories = new ArrayList<ClassesDirectory>();

    @Input
    public JolParameters.Layout getLayout() {
        return this.fLayout != null ? this.fLayout : JolParameters.Layout.HOTSPOT;
    }

    public void setLayout(JolParameters.Layout pLayout) {
        this.fLayout = pLayout;
    }

    @Input
    public JolParameters.DataModel getDataModel() {
        return this.fDataModel != null ? this.fDataModel : JolParameters.DataModel.x86_64_COMPRESSED;
    }

    public void setDataModel(JolParameters.DataModel pDataModel) {
        this.fDataModel = pDataModel;
    }

    @Input
    public int getAlignment() {
        return this.fAlignment;
    }

    public void setAlignment(int pAlignment) {
        this.fAlignment = pAlignment;
    }

    @Input
    public String getToolVersion() {
        return this.fToolVersion != null ? this.fToolVersion : DEFAULT_TOOL_VERSION;
    }

    public void setToolVersion(String pToolVersion) {
        this.fToolVersion = pToolVersion;
    }

    @Input
    public Collection<String> getClasses() {
        return this.fClasses;
    }

    public void setClasses(Collection<String> pClasses) {
        this.fClasses = pClasses != null ? pClasses : new ArrayList();
    }

    public void setClasses(String ... pClasses) {
        this.fClasses = Arrays.asList(pClasses);
    }

    @InputFiles
    public FileCollection getAnalysisClassPath() {
        return this.fAnalysisClassPath != null ? this.fAnalysisClassPath : this.getProject().files(new Object[0]);
    }

    public void setAnalysisClassPath(Object pAnalysisClassPath) {
        this.fAnalysisClassPath = pAnalysisClassPath != null ? this.getProject().files(new Object[]{pAnalysisClassPath}) : null;
    }

    private void addToAnalysisClassPath(FileCollection pClassPath) {
        this.fAnalysisClassPath = this.fAnalysisClassPath != null ? this.fAnalysisClassPath.plus(pClassPath) : pClassPath;
    }

    @InputFiles
    public FileCollection getToolClassPath() {
        return this.fToolClassPath != null ? this.fToolClassPath : this.getProject().files(new Object[0]);
    }

    public void setToolClassPath(FileCollection pToolClassPath) {
        this.fToolClassPath = pToolClassPath;
    }

    @InputFiles
    public Collection<File> getClassesDirectories() {
        return this.fClassesDirectories.stream().map(d -> d.fDirectory).collect(Collectors.toList());
    }

    public void classesDirectory(Object pDirectoryPath) {
        this.classesDirectory(pDirectoryPath, null);
    }

    public void classesDirectory(Object pDirectoryPath, Closure<?> pFilterClosure) {
        File aDirectory = this.getProject().file(pDirectoryPath);
        this.addToAnalysisClassPath((FileCollection)this.getProject().files(new Object[]{aDirectory}));
        this.getLogger().debug("Adding classes directory {}", (Object)aDirectory.getAbsolutePath());
        this.fClassesDirectories.add(new ClassesDirectory(aDirectory, JolTask.createFilter(pFilterClosure)));
    }

    public void sourceSet(SourceSet pSourceSet) {
        this.sourceSet(pSourceSet, null);
    }

    public void sourceSet(SourceSet pSourceSet, Closure<?> pFilterClosure) {
        this.getLogger().debug("Adding source set {}", (Object)pSourceSet.getName());
        for (File aClassesDirectory : pSourceSet.getOutput().getClassesDirs()) {
            this.classesDirectory(aClassesDirectory, pFilterClosure);
        }
        this.addToAnalysisClassPath(pSourceSet.getRuntimeClasspath());
    }

    @Override
    @Nested
    public JolReports getReports() {
        return this.fReports;
    }

    @Override
    public JolReports reports(Closure pClosure) {
        this.fReports.configure(pClosure);
        return this.fReports;
    }

    @Override
    public JolReports reports(Action<? super JolReports> pAction) {
        pAction.execute((Object)this.fReports);
        return this.fReports;
    }

    @TaskAction
    public void run() {
        SingleFileReport aXmlReport = this.fReports.getXml();
        if (aXmlReport.isEnabled()) {
            JolResult aResult = this.runJolAnalysis();
            if (aResult != null) {
                this.createXmlReport(aResult, aXmlReport);
                TransformingReport aHtmlReport = this.fReports.getHtml();
                if (aHtmlReport.isEnabled()) {
                    aHtmlReport.transform();
                }
            }
        } else {
            this.getLogger().info("Jol XML report is disabled, no analysis will be performed");
        }
    }

    void setupReports() {
        this.fReports = new JolReportsImpl(this);
        this.onlyIf(_ignore -> this.getReports().getXml().isEnabled());
        this.fReports.setInputsAndOutputs((Task)this);
    }

    void maybeConfigureDefaultClasses() {
        if (this.fClasses.isEmpty() && this.fClassesDirectories.isEmpty()) {
            this.getLogger().debug("No classes explicitly configured, defaulting to the main source set");
            SourceSet aMainSourceSet = Projects.getSourceSet(this.getProject(), "main");
            if (aMainSourceSet != null) {
                this.sourceSet(aMainSourceSet);
            }
        }
    }

    private JolResult runJolAnalysis() {
        try {
            for (ClassesDirectory aClassesDirectory : this.fClassesDirectories) {
                this.getLogger().debug("Adding classes for analysis from {}", (Object)aClassesDirectory);
                aClassesDirectory.addClassNames(this.fClasses, this.getProject());
            }
            JolParameters aParameters = new JolParameters(this.getLayout(), this.getDataModel(), this.getAlignment());
            return this.loadJolRunner().analyze(this.fClasses, aParameters);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.getLogger().error("Could not create an instance of '{}{}'", new Object[]{IMPLEMENTATION_PACKAGE, IMPLEMENTATION_CLASS, e});
            return null;
        }
    }

    private void createXmlReport(JolResult pResult, SingleFileReport pXmlReport) {
        try (JolXmlReportWriter aWriter = new JolXmlReportWriter(pXmlReport);){
            aWriter.writeReport(pResult);
        }
        catch (IOException ioe) {
            this.getLogger().error("Failed to create Jol report {}", (Object)pXmlReport.getDestination(), (Object)ioe);
        }
    }

    private JolRunner loadJolRunner() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ExternalToolLoader<JolRunner> aLoader = new ExternalToolLoader<JolRunner>(JolRunner.class, IMPLEMENTATION_PACKAGE, IMPLEMENTATION_CLASS, this::createJolRunnerClassPath);
        JolRunner aJolRunner = aLoader.createToolProxy();
        aJolRunner.init(this.getToolVersion());
        return aJolRunner;
    }

    private FileCollection createJolRunnerClassPath() {
        return this.getToolClassPath().plus(this.getAnalysisClassPath());
    }

    private static PatternFilterable createFilter(Closure<?> pFilterClosure) {
        if (pFilterClosure != null) {
            return (PatternFilterable)ConfigureUtil.configure(pFilterClosure, (Object)new PatternSet());
        }
        return null;
    }

    public static class ClassesDirectory {
        final File fDirectory;
        final PatternFilterable fFilter;

        ClassesDirectory(File pDirectory, PatternFilterable pFilter) {
            this.fDirectory = Objects.requireNonNull(pDirectory);
            this.fFilter = pFilter;
        }

        void addClassNames(Collection<String> pClassNames, Project pProject) {
            if (!this.fDirectory.exists()) {
                return;
            }
            FileTree aClassFiles = pProject.files(new Object[]{this.fDirectory}).getAsFileTree();
            if (this.fFilter != null) {
                aClassFiles = aClassFiles.matching(this.fFilter);
            }
            Path aParentPath = this.fDirectory.toPath();
            for (File aClassFile : aClassFiles) {
                if ("module-info.class".equals(aClassFile.getName())) continue;
                String aRelativePath = aParentPath.relativize(aClassFile.toPath()).toString();
                int aClassSuffixPos = aRelativePath.indexOf(".class");
                if (aClassSuffixPos >= 0) {
                    aRelativePath = aRelativePath.substring(0, aClassSuffixPos);
                }
                pClassNames.add(aRelativePath.replace(File.separatorChar, '.'));
            }
        }

        public String toString() {
            return this.fDirectory.getAbsolutePath();
        }
    }
}

