/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.jol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class JolResult {
    private final String fVersion;
    private final String fDescription;
    private final Map<String, PackageLayout> fPackages = new TreeMap<String, PackageLayout>();
    private long fInternalAlignmentGapSize;
    private long fExternalAlignmentGapSize;

    public JolResult(String pVersion, String pDescription) {
        this.fVersion = Objects.requireNonNull(pVersion);
        this.fDescription = Objects.requireNonNull(pDescription);
    }

    public String getVersion() {
        return this.fVersion;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public int getNumPackages() {
        return this.fPackages.size();
    }

    public Iterable<PackageLayout> getPackages() {
        return this.fPackages.values();
    }

    public long getInternalAlignmentGapSize() {
        return this.fInternalAlignmentGapSize;
    }

    public long getExternalAlignmentGapSize() {
        return this.fExternalAlignmentGapSize;
    }

    public void add(ClassLayout pClassLayout) {
        this.fPackages.computeIfAbsent(pClassLayout.getPackageName(), PackageLayout::new).add(pClassLayout);
        this.fInternalAlignmentGapSize += pClassLayout.getInternalAlignmentGapSize();
        this.fExternalAlignmentGapSize += pClassLayout.getExternalAlignmentGapSize();
    }

    public static class FieldLayout {
        private final String fName;
        private final String fType;
        private final long fOffset;
        private final long fSize;

        public FieldLayout(String pName, String pType, long pOffset, long pSize) {
            this.fName = Objects.requireNonNull(pName);
            this.fType = Objects.requireNonNull(pType);
            this.fOffset = pOffset;
            this.fSize = pSize;
        }

        public String getName() {
            return this.fName;
        }

        public String getType() {
            return this.fType;
        }

        public long getOffset() {
            return this.fOffset;
        }

        public long getSize() {
            return this.fSize;
        }
    }

    public static class ClassLayout {
        private static final String GAP = "gap";
        private static final String FIELD_ALIGNMENT = "internal field alignment";
        private static final String NEXT_OBJECT_ALIGNMENT = "next object alignment";
        private final String fPackageName;
        private final String fClassName;
        private final String fEnclosingClassName;
        private final String fFullClassName;
        private final String fFullyQualifiedName;
        private final Collection<FieldLayout> fFields;
        private final int fHeaderSize;
        private final long fInstanceSize;
        private final long fInternalAlignmentGapSize;
        private final long fExternalAlignmentGapSize;

        public ClassLayout(String pClassName, String pPackageName, String pEnclosingClassName, int pHeaderSize, long pInstanceSize, Collection<FieldLayout> pFields) {
            this.fClassName = Objects.requireNonNull(pClassName);
            this.fPackageName = Objects.requireNonNull(pPackageName);
            this.fEnclosingClassName = pEnclosingClassName;
            this.fFullClassName = this.fEnclosingClassName != null ? this.fEnclosingClassName + '.' + this.fClassName : this.fClassName;
            this.fFullyQualifiedName = this.fPackageName.isEmpty() ? this.fFullClassName : this.fPackageName + '.' + this.fFullClassName;
            this.fHeaderSize = pHeaderSize;
            this.fInstanceSize = pInstanceSize;
            this.fFields = new ArrayList<FieldLayout>(pFields.size());
            long aNextExpectedOffset = pHeaderSize;
            long aTotalFieldAlignmentGapSizes = 0L;
            for (FieldLayout aField : pFields) {
                long aGap = aField.getOffset() - aNextExpectedOffset;
                if (aGap > 0L) {
                    this.fFields.add(new FieldLayout(FIELD_ALIGNMENT, GAP, aNextExpectedOffset, aGap));
                    aTotalFieldAlignmentGapSizes += aGap;
                }
                this.fFields.add(aField);
                aNextExpectedOffset = aField.getOffset() + aField.getSize();
            }
            if (pInstanceSize != aNextExpectedOffset) {
                this.fExternalAlignmentGapSize = pInstanceSize - aNextExpectedOffset;
                this.fFields.add(new FieldLayout(NEXT_OBJECT_ALIGNMENT, GAP, aNextExpectedOffset, this.fExternalAlignmentGapSize));
            } else {
                this.fExternalAlignmentGapSize = 0L;
            }
            this.fInternalAlignmentGapSize = aTotalFieldAlignmentGapSizes;
        }

        public String getPackageName() {
            return this.fPackageName;
        }

        public String getClassName() {
            return this.fClassName;
        }

        public String getEnclosingClassName() {
            return this.fEnclosingClassName;
        }

        public String getFullClassName() {
            return this.fFullClassName;
        }

        public String getFullyQualifiedName() {
            return this.fFullyQualifiedName;
        }

        public int getNumFields() {
            return this.fFields.size();
        }

        public Iterable<FieldLayout> getFields() {
            return this.fFields;
        }

        public int getHeaderSize() {
            return this.fHeaderSize;
        }

        public long getInstanceSize() {
            return this.fInstanceSize;
        }

        public long getInternalAlignmentGapSize() {
            return this.fInternalAlignmentGapSize;
        }

        public long getExternalAlignmentGapSize() {
            return this.fExternalAlignmentGapSize;
        }
    }

    public static class PackageLayout {
        private final String fName;
        private final List<ClassLayout> fClasses = new ArrayList<ClassLayout>();
        private long fInternalAlignmentGapSize;
        private long fExternalAlignmentGapSize;
        private boolean fIsSorted;

        PackageLayout(String pPackageName) {
            this.fName = Objects.requireNonNull(pPackageName);
        }

        void add(ClassLayout pClassLayout) {
            this.fClasses.add(pClassLayout);
            this.fInternalAlignmentGapSize += pClassLayout.getInternalAlignmentGapSize();
            this.fExternalAlignmentGapSize += pClassLayout.getExternalAlignmentGapSize();
            this.fIsSorted = false;
        }

        public String getName() {
            return this.fName;
        }

        public int getNumClasses() {
            return this.fClasses.size();
        }

        public Iterable<ClassLayout> getClasses() {
            if (!this.fIsSorted) {
                this.fClasses.sort(Comparator.comparing(ClassLayout::getFullClassName));
                this.fIsSorted = true;
            }
            return this.fClasses;
        }

        public long getInternalAlignmentGapSize() {
            return this.fInternalAlignmentGapSize;
        }

        public long getExternalAlignmentGapSize() {
            return this.fExternalAlignmentGapSize;
        }
    }
}

