/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.dependency;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.Project;
import org.myire.quill.common.GradlePrettyPrinter;
import org.myire.quill.common.PrettyPrintable;
import org.myire.quill.dependency.Dependencies;
import org.myire.quill.dependency.DependencySpec;

public class ProjectDependencySpec
extends DependencySpec {
    private static final String ATTRIBUTE_PATH = "path";
    private final String fProjectPath;

    public ProjectDependencySpec(String pConfiguration, String pProjectPath) {
        super(pConfiguration);
        this.fProjectPath = Objects.requireNonNull(pProjectPath);
    }

    public String getProjectPath() {
        return this.fProjectPath;
    }

    public Map<String, String> toMap() {
        return Collections.singletonMap(ATTRIBUTE_PATH, this.fProjectPath);
    }

    @Override
    public String toDependencyNotation() {
        return "project(" + PrettyPrintable.quote(this.fProjectPath) + ")";
    }

    @Override
    public boolean addTo(Project pProject) {
        return Dependencies.addDependency(pProject, this);
    }

    @Override
    public void prettyPrint(GradlePrettyPrinter pPrinter) {
        if (this.hasNonDefaultAttribute()) {
            pPrinter.printMethodCall(this.getConfiguration(), this.toDependencyNotation(), false, true);
            pPrinter.printClosure(null, this::printClosureBody);
        } else {
            pPrinter.printMethodCall(this.getConfiguration(), this.toDependencyNotation(), false, false);
        }
    }
}

