/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.dashboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.Pmd;
import org.gradle.api.reporting.Report;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.jacoco.tasks.JacocoReport;
import org.myire.quill.common.ProjectAware;
import org.myire.quill.common.Util;
import org.myire.quill.cpd.CpdTask;
import org.myire.quill.dashboard.DashboardSection;
import org.myire.quill.jol.JolTask;
import org.myire.quill.report.FormatChoiceReport;
import org.myire.quill.report.ReportingEntity;
import org.myire.quill.scent.ScentTask;

class DashboardSectionFactory
extends ProjectAware {
    private static final String XSL_RESOURCE_CHECKSTYLE = "/org/myire/quill/rsrc/report/checkstyle/checkstyle_summary.xsl";
    private static final String XSL_RESOURCE_COBERTURA = "/org/myire/quill/rsrc/report/cobertura/cobertura_summary.xsl";
    private static final String XSL_RESOURCE_CPD = "/org/myire/quill/rsrc/report/cpd/cpd_summary.xsl";
    private static final String XSL_RESOURCE_JACOCO = "/org/myire/quill/rsrc/report/jacoco/jacoco_summary.xsl";
    private static final String XSL_RESOURCE_JDEPEND = "/org/myire/quill/rsrc/report/jdepend/jdepend_summary.xsl";
    private static final String XSL_RESOURCE_JOL = "/org/myire/quill/rsrc/report/jol/jol_summary.xsl";
    private static final String XSL_RESOURCE_JUNIT = "/org/myire/quill/rsrc/report/junit/junit_summary.xsl";
    private static final String XSL_RESOURCE_PMD = "/org/myire/quill/rsrc/report/pmd/pmd_summary.xsl";
    private static final String XSL_RESOURCE_SCENT = "/org/myire/quill/rsrc/report/scent/scent_summary.xsl";
    private static final String XSL_RESOURCE_SPOTBUGS = "/org/myire/quill/rsrc/report/spotbugs/spotbugs_summary.xsl";
    private static final String ENHANCED_CHECK_TASK_REPORT_NAME = "quillHtmlReport";
    private static final String JUNIT_SUMMARY_REPORT_NAME = "junitSummaryReport";
    private static final Class<? extends Task> cSpotBugsTaskClass = DashboardSectionFactory.getTaskClass("com.github.spotbugs.SpotBugsTask");
    private static final Class<? extends Task> cSpotBugs4TaskClass = DashboardSectionFactory.getTaskClass("com.github.spotbugs.snom.SpotBugsTask");
    private static final Class<? extends Task> cJDependTaskClass = DashboardSectionFactory.getTaskClass("org.gradle.api.plugins.quality.JDepend");
    private static final Class<? extends Task> cCoberturaReportsTaskClass = DashboardSectionFactory.getTaskClass("org.myire.quill.cobertura.CoberturaReportsTask");

    DashboardSectionFactory(Project pProject) {
        super(pProject);
    }

    DashboardSection create(Task pTask) {
        if (pTask instanceof Checkstyle) {
            return this.createCheckstyleSection((Checkstyle)pTask);
        }
        if (pTask instanceof CpdTask) {
            return this.createCpdSection((CpdTask)pTask);
        }
        if (pTask instanceof JacocoReport) {
            return this.createJacocoSection((JacocoReport)pTask);
        }
        if (pTask instanceof Test) {
            return this.createJUnitSection((Test)pTask);
        }
        if (pTask instanceof Pmd) {
            return this.createPmdSection((Pmd)pTask);
        }
        if (pTask instanceof ScentTask) {
            return this.createScentSection((ScentTask)pTask);
        }
        if (pTask instanceof JolTask) {
            return this.createJolSection((JolTask)pTask);
        }
        if (cSpotBugsTaskClass != null && cSpotBugsTaskClass.isAssignableFrom(pTask.getClass())) {
            return this.createSpotBugsSection(pTask);
        }
        if (cSpotBugs4TaskClass != null && cSpotBugs4TaskClass.isAssignableFrom(pTask.getClass())) {
            return this.createSpotBugsSection(pTask);
        }
        if (cJDependTaskClass != null && cJDependTaskClass.isAssignableFrom(pTask.getClass())) {
            return this.createJDependSection(pTask);
        }
        if (cCoberturaReportsTaskClass != null && cCoberturaReportsTaskClass.isAssignableFrom(pTask.getClass())) {
            return this.createCoberturaSection(pTask);
        }
        return null;
    }

    Collection<DashboardSection> createAvailableDefaultSections() {
        ArrayList<DashboardSection> aSections = new ArrayList<DashboardSection>();
        this.addSectionsForTaskType(aSections, Test.class, this::createJUnitSection);
        this.addSectionsForTaskType(aSections, JacocoReport.class, this::createJacocoSection);
        if (cCoberturaReportsTaskClass != null) {
            this.addSectionsForTaskType(aSections, cCoberturaReportsTaskClass, this::createCoberturaSection);
        }
        if (cSpotBugsTaskClass != null) {
            this.addSectionsForTaskType(aSections, cSpotBugsTaskClass, this::createSpotBugsMainSection);
        }
        if (cSpotBugs4TaskClass != null) {
            this.addSectionsForTaskType(aSections, cSpotBugs4TaskClass, this::createSpotBugsMainSection);
        }
        this.addSectionsForTaskType(aSections, Checkstyle.class, this::createCheckstyleMainSection);
        this.addSectionsForTaskType(aSections, Pmd.class, this::createPmdMainSection);
        this.addSectionsForTaskType(aSections, CpdTask.class, this::createCpdSection);
        this.addSectionsForTaskType(aSections, ScentTask.class, this::createScentSection);
        this.addSectionsForTaskType(aSections, JolTask.class, this::createJolSection);
        if (cJDependTaskClass != null) {
            this.addSectionsForTaskType(aSections, cJDependTaskClass, this::createJDependMainSection);
        }
        return aSections;
    }

    private <T extends Task> void addSectionsForTaskType(Collection<DashboardSection> pSections, Class<T> pTaskType, Function<T, DashboardSection> pCreator) {
        this.getProject().getTasks().withType(pTaskType).stream().map(pCreator).filter(Objects::nonNull).forEach(pSections::add);
    }

    private DashboardSection createCheckstyleMainSection(Checkstyle pTask) {
        if ("checkstyleMain".equals(pTask.getName())) {
            return this.createCheckstyleSection(pTask);
        }
        return null;
    }

    private DashboardSection createCheckstyleSection(Checkstyle pTask) {
        Report aDetailedReport = null;
        Convention aConvention = pTask.getConvention();
        if (aConvention != null) {
            aDetailedReport = (Report)aConvention.findByName(ENHANCED_CHECK_TASK_REPORT_NAME);
        }
        if (aDetailedReport == null) {
            aDetailedReport = pTask.getReports().getHtml();
        }
        return new DashboardSection(pTask.getProject(), pTask.getName(), (Report)pTask.getReports().getXml(), aDetailedReport, XSL_RESOURCE_CHECKSTYLE);
    }

    private DashboardSection createCpdSection(CpdTask pTask) {
        FormatChoiceReport aPrimaryReport = pTask.getReports().getPrimary();
        if ("xml".equals(aPrimaryReport.getFormat())) {
            return new DashboardSection(pTask.getProject(), pTask.getName(), (Report)aPrimaryReport, (Report)pTask.getReports().getHtml(), XSL_RESOURCE_CPD);
        }
        pTask.getLogger().debug("Task '{}' creates a '{}' report, cannot create a dashboard section for it", (Object)pTask.getName(), (Object)aPrimaryReport.getFormat());
        return null;
    }

    private DashboardSection createJacocoSection(JacocoReport pTask) {
        return new DashboardSection(pTask.getProject(), pTask.getName(), (Report)pTask.getReports().getXml(), (Report)pTask.getReports().getHtml(), XSL_RESOURCE_JACOCO);
    }

    private DashboardSection createJDependMainSection(Task pTask) {
        if ("jdependMain".equals(pTask.getName())) {
            return this.createJDependSection(pTask);
        }
        return null;
    }

    private DashboardSection createJDependSection(Task pTask) {
        return DashboardSectionFactory.createReportingTaskSection(pTask, XSL_RESOURCE_JDEPEND);
    }

    private DashboardSection createJolSection(JolTask pTask) {
        return new DashboardSection(pTask.getProject(), pTask.getName(), (Report)pTask.getReports().getXml(), (Report)pTask.getReports().getHtml(), XSL_RESOURCE_JOL);
    }

    private DashboardSection createJUnitSection(Test pTask) {
        Report aSummaryReport = null;
        Convention aConvention = pTask.getConvention();
        if (aConvention != null) {
            aSummaryReport = (Report)aConvention.findByName(JUNIT_SUMMARY_REPORT_NAME);
        }
        if (aSummaryReport != null) {
            return new DashboardSection(pTask.getProject(), pTask.getName(), aSummaryReport, (Report)pTask.getReports().getHtml(), XSL_RESOURCE_JUNIT);
        }
        this.getProjectLogger().debug("Task '{}' has no '{}' report, cannot create dashboard section for it", (Object)pTask.getName(), (Object)JUNIT_SUMMARY_REPORT_NAME);
        return null;
    }

    private DashboardSection createPmdMainSection(Pmd pTask) {
        if ("pmdMain".equals(pTask.getName())) {
            return this.createPmdSection(pTask);
        }
        return null;
    }

    private DashboardSection createPmdSection(Pmd pTask) {
        Report aDetailedReport = null;
        Convention aConvention = pTask.getConvention();
        if (aConvention != null) {
            aDetailedReport = (Report)aConvention.findByName(ENHANCED_CHECK_TASK_REPORT_NAME);
        }
        if (aDetailedReport == null) {
            aDetailedReport = pTask.getReports().getHtml();
        }
        return new DashboardSection(pTask.getProject(), pTask.getName(), (Report)pTask.getReports().getXml(), aDetailedReport, XSL_RESOURCE_PMD);
    }

    private DashboardSection createScentSection(ScentTask pTask) {
        return new DashboardSection(pTask.getProject(), pTask.getName(), (Report)pTask.getReports().getXml(), (Report)pTask.getReports().getHtml(), XSL_RESOURCE_SCENT);
    }

    private DashboardSection createSpotBugsMainSection(Task pTask) {
        if ("spotbugsMain".equals(pTask.getName())) {
            return this.createSpotBugsSection(pTask);
        }
        return null;
    }

    private DashboardSection createSpotBugsSection(Task pTask) {
        return DashboardSectionFactory.createReportingTaskSection(pTask, XSL_RESOURCE_SPOTBUGS);
    }

    private DashboardSection createCoberturaSection(Task pTask) {
        Object aReports;
        Report aXmlReport;
        if (pTask instanceof ReportingEntity && (aXmlReport = (aReports = ((ReportingEntity)pTask).getReports()).getReportByName("coberturaXml")) != null) {
            return new DashboardSection(pTask.getProject(), pTask.getName(), aXmlReport, aReports.getReportByName("coberturaHtml"), XSL_RESOURCE_COBERTURA);
        }
        return null;
    }

    private static DashboardSection createReportingTaskSection(Task pTask, String pXslResource) {
        Object aReportsProperty;
        NamedDomainObjectCollection aReports = null;
        if (pTask.hasProperty("reports") && (aReportsProperty = pTask.property("reports")) instanceof NamedDomainObjectCollection) {
            aReports = (NamedDomainObjectCollection)aReportsProperty;
        }
        if (aReports == null) {
            return null;
        }
        Object aXmlReport = Util.findByNameIgnoreCase(aReports, "xml");
        if (!(aXmlReport instanceof Report)) {
            return null;
        }
        Object aDetailedReport = null;
        Convention aConvention = pTask.getConvention();
        if (aConvention != null) {
            aDetailedReport = aConvention.findByName(ENHANCED_CHECK_TASK_REPORT_NAME);
        }
        if (aDetailedReport == null) {
            aDetailedReport = Util.findByNameIgnoreCase(aReports, "html");
        }
        if (aDetailedReport != null && !(aDetailedReport instanceof Report)) {
            aDetailedReport = null;
        }
        return new DashboardSection(pTask.getProject(), pTask.getName(), (Report)aXmlReport, (Report)aDetailedReport, pXslResource);
    }

    private static Class<? extends Task> getTaskClass(String pClassName) {
        try {
            Class<?> aClass = Class.forName(pClassName);
            if (Task.class.isAssignableFrom(aClass)) {
                return aClass;
            }
            return null;
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
    }
}

