/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.dashboard;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.Report;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.myire.quill.common.ProjectAware;
import org.myire.quill.report.ReportBuilder;
import org.myire.quill.report.TransformingReport;

public class DashboardSection
extends ProjectAware {
    private final String fName;
    private final Report fReport;
    private final Report fDetailedReport;
    private final String fXslResource;
    private File fXslFile;

    DashboardSection(Project pProject, String pName, Report pReport, Report pDetailedReport, String pXslResource) {
        super(pProject);
        this.fName = pName;
        this.fReport = pReport;
        this.fDetailedReport = pDetailedReport;
        this.fXslResource = pXslResource;
    }

    DashboardSection(Project pProject, String pName, Report pReport, Report pDetailedReport, File pXslFile) {
        super(pProject);
        this.fName = pName;
        this.fReport = pReport;
        this.fDetailedReport = pDetailedReport;
        this.fXslResource = null;
        this.fXslFile = pXslFile;
    }

    @Input
    public String getName() {
        return this.fName;
    }

    @Nested
    public Report getReport() {
        return this.fReport;
    }

    @Nested
    @Optional
    public Report getDetailedReport() {
        return this.fDetailedReport;
    }

    @InputFile
    @Optional
    public File getXslFile() {
        return this.fXslFile;
    }

    public void setXslFile(Object pFile) {
        this.fXslFile = pFile != null ? this.getProject().file(pFile) : null;
    }

    void writeTo(ReportBuilder pReportBuilder) {
        if (this.fReport.isEnabled()) {
            this.getProjectLogger().debug("Creating dashboard section '{}'", (Object)this.fName);
            this.transform(pReportBuilder);
        } else {
            this.getProjectLogger().debug("Report '{}' for dashboard section '{}' is disabled, skipping", (Object)this.fReport.getName(), (Object)this.fName);
        }
    }

    private void transform(ReportBuilder pReportBuilder) {
        File aInputFile = this.fReport.getDestination();
        if (aInputFile == null) {
            this.getProjectLogger().error("The report for the '{}' dashboard section has no destination file", (Object)this.fName);
        } else if (!aInputFile.exists()) {
            this.getProjectLogger().error("The report file '{}' for the '{}' dashboard section does not exist, skipping", (Object)aInputFile.getAbsolutePath(), (Object)this.fName);
        } else if (!aInputFile.canRead()) {
            this.getProjectLogger().error("The report file '{}' for the '{}' dashboard section is not readable, skipping", (Object)aInputFile.getAbsolutePath(), (Object)this.fName);
        } else {
            Map<String, Object> aXslParams = this.createXslParameters(pReportBuilder.getDestination());
            if (this.fXslFile != null) {
                pReportBuilder.transform(aInputFile, this.fXslFile, aXslParams);
            } else {
                pReportBuilder.transform(aInputFile, this.fXslResource, aXslParams);
            }
        }
    }

    private Map<String, Object> createXslParameters(File pDashboardReportFile) {
        HashMap<String, Object> aParams = new HashMap<String, Object>();
        TransformingReport.applyProjectRootXslParameter(this.getProject(), aParams::put);
        File aDetailedReport = this.getDetailedReportFile();
        if (aDetailedReport != null && aDetailedReport.exists()) {
            String aRelativePath = pDashboardReportFile.toPath().getParent().relativize(aDetailedReport.toPath()).toString();
            aParams.put("detailed-report-path", aRelativePath);
        }
        return aParams;
    }

    private File getDetailedReportFile() {
        if (this.fDetailedReport == null || !this.fDetailedReport.isEnabled()) {
            return null;
        }
        if (this.fDetailedReport instanceof DirectoryReport) {
            return ((DirectoryReport)this.fDetailedReport).getEntryPoint();
        }
        return this.fDetailedReport.getDestination();
    }
}

