/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.common;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public class Resolver<T> {
    private final Class<T> fType;

    public Resolver(Class<T> pType) {
        this.fType = Objects.requireNonNull(pType);
    }

    public T resolve(Object pObject) {
        if (pObject == null) {
            return null;
        }
        if (this.fType.isInstance(pObject)) {
            return this.fType.cast(pObject);
        }
        if (pObject instanceof Callable) {
            return this.resolve(Resolver.uncheckedCall((Callable)pObject));
        }
        if (pObject instanceof Supplier) {
            return this.resolve(((Supplier)pObject).get());
        }
        return null;
    }

    private static Object uncheckedCall(Callable<?> pCallable) {
        try {
            return pCallable.call();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

