/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.common;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;

public class Providers {
    private static final MethodHandle PROJECT_LAYOUT_FILE_PROPERTY;
    private static final MethodHandle PROJECT_LAYOUT_DIRECTORY_PROPERTY;
    private static final MethodHandle OBJECT_FACTORY_FILE_PROPERTY;
    private static final MethodHandle OBJECT_FACTORY_DIRECTORY_PROPERTY;

    public static RegularFileProperty createFileProperty(Project pProject) {
        RegularFileProperty aProperty = null;
        try {
            if (OBJECT_FACTORY_FILE_PROPERTY != null) {
                aProperty = OBJECT_FACTORY_FILE_PROPERTY.invokeExact(pProject.getObjects());
            } else if (PROJECT_LAYOUT_FILE_PROPERTY != null) {
                aProperty = PROJECT_LAYOUT_FILE_PROPERTY.invokeExact(pProject.getLayout());
            }
        }
        catch (Throwable t) {
            pProject.getLogger().error("Could not create a regular file property", t);
        }
        return aProperty;
    }

    public static DirectoryProperty createDirectoryProperty(Project pProject) {
        DirectoryProperty aProperty = null;
        try {
            if (OBJECT_FACTORY_DIRECTORY_PROPERTY != null) {
                aProperty = OBJECT_FACTORY_DIRECTORY_PROPERTY.invokeExact(pProject.getObjects());
            } else if (PROJECT_LAYOUT_DIRECTORY_PROPERTY != null) {
                aProperty = PROJECT_LAYOUT_DIRECTORY_PROPERTY.invokeExact(pProject.getLayout());
            }
        }
        catch (Throwable t) {
            pProject.getLogger().error("Could not create a directory property", t);
        }
        return aProperty;
    }

    private static MethodHandle lookupVirtualMethod(MethodHandles.Lookup pLookup, Class<?> pClass, String pMethodName, MethodType pMethodType) {
        try {
            return pLookup.findVirtual(pClass, pMethodName, pMethodType);
        }
        catch (ReflectiveOperationException | RuntimeException ignore) {
            return null;
        }
    }

    static {
        MethodHandles.Lookup aLookup = MethodHandles.lookup();
        MethodType aRegularFilePropertyMethodType = MethodType.methodType(RegularFileProperty.class);
        MethodType aDirectoryPropertyMethodType = MethodType.methodType(DirectoryProperty.class);
        PROJECT_LAYOUT_FILE_PROPERTY = Providers.lookupVirtualMethod(aLookup, ProjectLayout.class, "fileProperty", aRegularFilePropertyMethodType);
        PROJECT_LAYOUT_DIRECTORY_PROPERTY = Providers.lookupVirtualMethod(aLookup, ProjectLayout.class, "directoryProperty", aDirectoryPropertyMethodType);
        OBJECT_FACTORY_FILE_PROPERTY = Providers.lookupVirtualMethod(aLookup, ObjectFactory.class, "fileProperty", aRegularFilePropertyMethodType);
        OBJECT_FACTORY_DIRECTORY_PROPERTY = Providers.lookupVirtualMethod(aLookup, ObjectFactory.class, "directoryProperty", aDirectoryPropertyMethodType);
    }
}

