/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.scent.impl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.myire.scent.collect.JavaMetricsCollector;
import org.myire.scent.file.JavaFileMetricsCollector;

class CollectingFileVisitor
extends SimpleFileVisitor<Path> {
    private static final String ERROR_LOG_TEMPLATE = "Failed to collect source code metrics from %s: %s";
    private final JavaFileMetricsCollector fDelegate;
    private final Logger fLogger = Logging.getLogger(CollectingFileVisitor.class);

    CollectingFileVisitor(JavaMetricsCollector pCollector, Charset pFileEncoding) {
        this.fDelegate = new JavaFileMetricsCollector(pCollector, pFileEncoding);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path pDirectory, BasicFileAttributes pAttributes) {
        this.fLogger.debug("Collecting source code metrics for Java files in " + pDirectory);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path pFile, BasicFileAttributes pAttributes) {
        try {
            return this.fDelegate.visitFile(pFile, pAttributes);
        }
        catch (IOException e) {
            this.fLogger.error(String.format(ERROR_LOG_TEMPLATE, pFile, e.getMessage()));
            return FileVisitResult.CONTINUE;
        }
    }

    @Override
    public FileVisitResult visitFileFailed(Path pFile, IOException pException) {
        this.fLogger.error(String.format(ERROR_LOG_TEMPLATE, pFile, pException.getMessage()));
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path pDirectory, IOException pException) {
        if (pException != null) {
            this.fLogger.error(String.format(ERROR_LOG_TEMPLATE, pDirectory, pException.getMessage()));
        }
        this.fLogger.debug("Done collecting source code metrics in " + pDirectory);
        return FileVisitResult.CONTINUE;
    }
}

