/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.scent;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.util.ConfigureUtil;
import org.myire.quill.common.Projects;
import org.myire.quill.report.DefaultSingleFileReport;
import org.myire.quill.report.ReportTransformingReport;
import org.myire.quill.report.TransformingReport;
import org.myire.quill.scent.ScentReports;
import org.myire.quill.scent.ScentTask;

class ScentReportsImpl
implements ScentReports {
    private static final String XML_REPORT_NAME = "scentXml";
    private static final String HTML_REPORT_NAME = "scentHtml";
    private static final String BUILTIN_SCENT_XSL = "/org/myire/quill/rsrc/report/scent/scent.xsl";
    private final SingleFileReport fXmlReport;
    private final TransformingReport fHtmlReport;

    ScentReportsImpl(ScentTask pTask) {
        Project aProject = pTask.getProject();
        this.fXmlReport = new DefaultSingleFileReport(aProject, XML_REPORT_NAME, "Scent XML report", new DefaultXmlReportDestination(aProject));
        this.fHtmlReport = new ReportTransformingReport(aProject, HTML_REPORT_NAME, "Scent HTML report", (Report)this.fXmlReport, BUILTIN_SCENT_XSL);
        this.fXmlReport.setEnabled(true);
        this.fHtmlReport.setEnabled(true);
    }

    @Override
    public SingleFileReport getXml() {
        return this.fXmlReport;
    }

    @Override
    public TransformingReport getHtml() {
        return this.fHtmlReport;
    }

    @Override
    public Report getReportByName(String pReportName) {
        if (XML_REPORT_NAME.equalsIgnoreCase(pReportName)) {
            return this.fXmlReport;
        }
        if (HTML_REPORT_NAME.equalsIgnoreCase(pReportName)) {
            return this.fHtmlReport;
        }
        return null;
    }

    public ScentReports configure(Closure pClosure) {
        ConfigureUtil.configureSelf((Closure)pClosure, (Object)this);
        return this;
    }

    private static class DefaultXmlReportDestination
    extends Closure<File> {
        private final Project fProject;

        DefaultXmlReportDestination(Project pProject) {
            super(null);
            this.fProject = pProject;
        }

        public File doCall(Object pValue) {
            return new File(Projects.createReportDirectorySpec(this.fProject, "scent"), "scent.xml");
        }
    }
}

