/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.scent;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaBasePlugin;
import org.myire.quill.common.Projects;
import org.myire.quill.scent.ScentTask;

public class ScentPlugin
implements Plugin<Project> {
    private static final String TASK_NAME = "scent";
    private static final String CONFIGURATION_NAME = "scent";
    private static final String SCENT_GROUP_ARTIFACT_ID = "org.myire:scent";
    private Project fProject;
    private ScentTask fTask;
    private Configuration fConfiguration;

    public void apply(Project pProject) {
        this.fProject = pProject;
        pProject.getPlugins().apply(JavaBasePlugin.class);
        this.fConfiguration = this.createConfiguration();
        this.fTask = this.createTask();
    }

    private Configuration createConfiguration() {
        Configuration aConfiguration = (Configuration)this.fProject.getConfigurations().maybeCreate("scent");
        aConfiguration.setVisible(false);
        aConfiguration.setTransitive(true);
        aConfiguration.setDescription("The Scent classes used by the Gradle tasks");
        aConfiguration.getIncoming().beforeResolve(ignore -> this.setConfigurationDependencies());
        return aConfiguration;
    }

    private void setConfigurationDependencies() {
        if (this.fConfiguration.getDependencies().isEmpty()) {
            String aID = "org.myire:scent:" + this.fTask.getToolVersion();
            this.fConfiguration.getDependencies().add((Object)this.fProject.getDependencies().create((Object)aID));
        }
    }

    private ScentTask createTask() {
        ScentTask aTask = (ScentTask)this.fProject.getTasks().create("scent", ScentTask.class);
        aTask.setDescription("Runs Scent to create a source code metrics report");
        aTask.setScentClasspath((FileCollection)this.fConfiguration);
        aTask.setupReports();
        aTask.addUpToDateCheck();
        Task aBuildTask = Projects.getTask(this.fProject, "build", Task.class);
        if (aBuildTask != null) {
            aBuildTask.dependsOn(new Object[]{aTask});
        }
        return aTask;
    }
}

