/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.repository;

import java.util.Objects;
import org.myire.quill.common.GradlePrettyPrinter;
import org.myire.quill.common.PrettyPrintable;

public class CredentialsSpec
implements PrettyPrintable {
    private static final String CLOSURE_CREDENTIALS = "credentials";
    private static final String ATTRIBUTE_USER_NAME = "username";
    private static final String ATTRIBUTE_PASSWORD = "password";
    private final String fUserName;
    private final String fPassword;

    public CredentialsSpec(String pUserName, String pPassword) {
        this.fUserName = Objects.requireNonNull(pUserName);
        this.fPassword = pPassword;
    }

    public String getUserName() {
        return this.fUserName;
    }

    public String getPassword() {
        return this.fPassword;
    }

    @Override
    public void prettyPrint(GradlePrettyPrinter pPrinter) {
        pPrinter.printClosure(CLOSURE_CREDENTIALS, this::printClosureBody);
    }

    private void printClosureBody(GradlePrettyPrinter pPrinter) {
        pPrinter.printAttribute(ATTRIBUTE_USER_NAME, this.getUserName());
        pPrinter.printAttribute(ATTRIBUTE_PASSWORD, this.getPassword());
    }
}

