/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.report;

import groovy.lang.Closure;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.Project;
import org.myire.quill.report.DefaultSingleFileReport;
import org.myire.quill.report.ReportBuilder;
import org.myire.quill.report.TransformingReport;

abstract class AbstractTransformingReport
extends DefaultSingleFileReport
implements TransformingReport {
    private static final String HTML_RESOURCE_REPORT_CSS = "/org/myire/quill/rsrc/report/report.css";
    private final String fXslResource;
    private File fXslFile;
    private final Map<String, Object> fXslParameters;

    protected AbstractTransformingReport(Project pProject, String pName, String pDisplayName, String pXslResource, Closure<File> pDefaultDestination) {
        super(pProject, pName, pDisplayName, pDefaultDestination);
        this.fXslResource = pXslResource;
        this.fXslParameters = TransformingReport.applyProjectRootXslParameter(pProject, Collections::singletonMap);
    }

    @Override
    public File getXslFile() {
        return this.fXslFile;
    }

    @Override
    public void setXslFile(Object pFile) {
        this.fXslFile = pFile != null ? this.getProject().file(pFile) : null;
    }

    @Override
    public boolean checkUpToDate() {
        if (!this.isEnabled()) {
            return true;
        }
        File aInputFile = this.getInputFile();
        if (aInputFile == null || !aInputFile.exists()) {
            return true;
        }
        File aDestination = this.getDestination();
        return aDestination.exists() && aDestination.lastModified() >= aInputFile.lastModified();
    }

    @Override
    public void transform() {
        if (!this.isEnabled()) {
            return;
        }
        File aInputFile = this.getInputFile();
        if (aInputFile != null) {
            if (aInputFile.canRead()) {
                this.transformFile(aInputFile);
            } else {
                this.getProjectLogger().error("The XML input file for the '{}' report is not readable", (Object)this.getDisplayName());
            }
        } else {
            this.getProjectLogger().error("The XML input file for the '{}' report does not exist", (Object)this.getDisplayName());
        }
    }

    protected abstract File getInputFile();

    private void transformFile(File pXmlFile) {
        File aDestination = this.getDestination();
        try {
            ReportBuilder aReportBuilder = new ReportBuilder(aDestination);
            if (this.fXslFile != null) {
                aReportBuilder.transform(pXmlFile, this.fXslFile, this.fXslParameters);
            } else {
                aReportBuilder.write("<html><head><title>");
                aReportBuilder.write(this.getDisplayName());
                aReportBuilder.write("</title><style type=\"text/css\">");
                aReportBuilder.copy(HTML_RESOURCE_REPORT_CSS);
                aReportBuilder.write("</style></head><body>");
                aReportBuilder.transform(pXmlFile, this.fXslResource, this.fXslParameters);
                aReportBuilder.write("</body></html>");
            }
            aReportBuilder.close();
        }
        catch (FileNotFoundException fnfe) {
            this.getProjectLogger().error("Could not create destination file '{}'", (Object)aDestination, (Object)fnfe);
        }
    }
}

