/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.maven.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.cli.configuration.SettingsXmlConfigurationProcessor;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.myire.quill.dependency.ModuleDependencySpec;
import org.myire.quill.maven.EffectivePomLoader;
import org.myire.quill.maven.impl.MirrorMatcher;
import org.myire.quill.repository.MavenRepositorySpec;
import org.myire.quill.repository.RepositorySpec;

public class EffectivePomLoaderImpl
implements EffectivePomLoader {
    private final Properties fSystemProperties = EffectivePomLoaderImpl.copySystemProperties();
    private File fPomFile = new File("pom.xml");
    private File fSettingsFile = SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE;
    private Settings fSettings;
    private MavenProject fProject;
    private final Logger fLogger = Logging.getLogger(EffectivePomLoaderImpl.class);

    @Override
    public void init(File pPomFile, File pSettingsFile) {
        this.fPomFile = Objects.requireNonNull(pPomFile);
        if (pSettingsFile != null) {
            this.fSettingsFile = pSettingsFile;
        }
    }

    @Override
    public Collection<ModuleDependencySpec> getDependencies() {
        MavenProject aProject = this.maybeLoadProject();
        return aProject.getModel().getDependencies().stream().map(EffectivePomLoaderImpl::toDependencySpec).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public Collection<RepositorySpec> getRepositories() {
        Settings aSettings = this.maybeLoadSettings();
        MirrorMatcher aMirrorMatcher = new MirrorMatcher(aSettings.getMirrors());
        MavenProject aProject = this.maybeLoadProject();
        Collection aRepositories = aProject.getRemoteArtifactRepositories().stream().filter(r -> !aMirrorMatcher.matches((ArtifactRepository)r)).filter(EffectivePomLoaderImpl::isUserDefinedRepo).map(EffectivePomLoaderImpl::toRepositorySpec).collect(Collectors.toCollection(ArrayList::new));
        aSettings.getMirrors().forEach(m -> aRepositories.add(EffectivePomLoaderImpl.toRepositorySpec(m)));
        aRepositories.forEach(r -> EffectivePomLoaderImpl.setCredentials(r, aSettings.getServers()));
        return aRepositories;
    }

    @Override
    public RepositorySpec getLocalRepository() {
        return new MavenRepositorySpec("local", this.maybeLoadSettings().getLocalRepository());
    }

    @Override
    public String getGroupId() {
        MavenProject aProject = this.maybeLoadProject();
        return aProject.getModel().getGroupId();
    }

    @Override
    public String getArtifactId() {
        MavenProject aProject = this.maybeLoadProject();
        return aProject.getModel().getArtifactId();
    }

    @Override
    public String getVersion() {
        MavenProject aProject = this.maybeLoadProject();
        return aProject.getModel().getVersion();
    }

    private MavenProject maybeLoadProject() {
        if (this.fProject != null) {
            return this.fProject;
        }
        this.fLogger.debug("Loading Pom file {}", (Object)this.fPomFile);
        try {
            PlexusContainer aContainer = EffectivePomLoaderImpl.createContainer();
            DefaultMavenExecutionRequest aExecutionRequest = new DefaultMavenExecutionRequest();
            aExecutionRequest.setSystemProperties(this.fSystemProperties);
            MavenExecutionRequestPopulator aRequestPopulator = (MavenExecutionRequestPopulator)aContainer.lookup(MavenExecutionRequestPopulator.class);
            aRequestPopulator.populateFromSettings((MavenExecutionRequest)aExecutionRequest, this.maybeLoadSettings());
            aRequestPopulator.populateDefaults((MavenExecutionRequest)aExecutionRequest);
            ProjectBuildingRequest aBuildingRequest = aExecutionRequest.getProjectBuildingRequest();
            aBuildingRequest.setProcessPlugins(false);
            ProjectBuilder aProjectBuilder = (ProjectBuilder)aContainer.lookup(ProjectBuilder.class);
            this.fProject = aProjectBuilder.build(this.fPomFile, aBuildingRequest).getProject();
            return this.fProject;
        }
        catch (MavenExecutionRequestPopulationException | ProjectBuildingException | PlexusContainerException | NoSuchRealmException | ComponentLookupException e) {
            throw new GradleException("Could not load the Pom file " + this.fPomFile, e);
        }
    }

    private Settings maybeLoadSettings() {
        if (this.fSettings != null) {
            return this.fSettings;
        }
        this.fLogger.debug("Loading Maven settings file {}", (Object)this.fSettingsFile);
        DefaultSettingsBuildingRequest aRequest = new DefaultSettingsBuildingRequest();
        aRequest.setUserSettingsFile(this.fSettingsFile);
        aRequest.setGlobalSettingsFile(SettingsXmlConfigurationProcessor.DEFAULT_GLOBAL_SETTINGS_FILE);
        aRequest.setSystemProperties(this.fSystemProperties);
        try {
            DefaultSettingsBuilder aBuilder = new DefaultSettingsBuilderFactory().newInstance();
            this.fSettings = aBuilder.build((SettingsBuildingRequest)aRequest).getEffectiveSettings();
            return this.fSettings;
        }
        catch (SettingsBuildingException sbe) {
            throw new GradleException("Could not load the Maven settings file " + this.fSettingsFile, (Throwable)sbe);
        }
    }

    private static ModuleDependencySpec toDependencySpec(Dependency pMavenDependency) {
        ModuleDependencySpec aSpec = new ModuleDependencySpec(pMavenDependency.getScope(), pMavenDependency.getGroupId(), pMavenDependency.getArtifactId(), pMavenDependency.getVersion());
        aSpec.setClassifier(pMavenDependency.getClassifier());
        String aType = pMavenDependency.getType();
        if (!"jar".equals(aType)) {
            aSpec.setExtension(aType);
        }
        pMavenDependency.getExclusions().forEach(e -> aSpec.addExclusion(e.getGroupId(), e.getArtifactId()));
        return aSpec;
    }

    private static RepositorySpec toRepositorySpec(ArtifactRepository pArtifactRepository) {
        MavenRepositorySpec aSpec = new MavenRepositorySpec(pArtifactRepository.getId(), pArtifactRepository.getUrl());
        Authentication aAuthentication = pArtifactRepository.getAuthentication();
        if (aAuthentication != null) {
            aSpec.setCredentials(aAuthentication.getUsername(), aAuthentication.getPassword());
        }
        return aSpec;
    }

    private static boolean isUserDefinedRepo(ArtifactRepository pArtifactRepository) {
        return !"central".equals(pArtifactRepository.getId());
    }

    private static RepositorySpec toRepositorySpec(Mirror pMirror) {
        return new MavenRepositorySpec(pMirror.getId(), pMirror.getUrl());
    }

    private static void setCredentials(RepositorySpec pRepository, List<Server> pServers) {
        if (pRepository.getCredentials() == null) {
            for (Server aServer : pServers) {
                if (!aServer.getId().equals(pRepository.getName())) continue;
                pRepository.setCredentials(aServer.getUsername(), aServer.getPassword());
            }
        }
    }

    private static PlexusContainer createContainer() throws PlexusContainerException, NoSuchRealmException {
        String aRealmID = "plexus.core";
        ClassWorld aClassWorld = new ClassWorld(aRealmID, ClassWorld.class.getClassLoader());
        ClassRealm aClassRealm = aClassWorld.getRealm(aRealmID);
        ContainerConfiguration aContainerConfiguration = new DefaultContainerConfiguration().setClassWorld(aClassWorld).setRealm(aClassRealm).setClassPathScanning("index").setAutoWiring(true).setName("mavenCore");
        return new DefaultPlexusContainer(aContainerConfiguration);
    }

    private static Properties copySystemProperties() {
        Properties aOriginal = System.getProperties();
        Properties aCopy = new Properties();
        for (String aPropertyName : aOriginal.stringPropertyNames()) {
            aCopy.put(aPropertyName, aOriginal.getProperty(aPropertyName));
        }
        return aCopy;
    }
}

