/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.maven;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.myire.quill.common.GradlePrettyPrinter;
import org.myire.quill.common.Projects;
import org.myire.quill.common.Tasks;
import org.myire.quill.dependency.DependencySpec;
import org.myire.quill.maven.MavenImportExtension;
import org.myire.quill.maven.PomImporter;
import org.myire.quill.repository.RepositorySpec;

public class PomConvertTask
extends DefaultTask {
    static final String TASK_NAME = "convertPom";
    private static final String TASK_DESCRIPTION = "Imports dependencies and/or repositories from a Maven pom file and writes them to a Gradle file";
    private File fPomFile;
    private File fDestination;
    private boolean fConvertRepositories = true;
    private boolean fConvertLocalRepository = true;
    private boolean fConvertDependencies = true;
    private boolean fOverwrite = true;

    void init(MavenImportExtension pExtension) {
        this.setDescription(TASK_DESCRIPTION);
        this.onlyIf(ignore -> this.fConvertRepositories || this.fConvertLocalRepository || this.fConvertDependencies);
        Tasks.optionalInputFile((Task)this, pExtension::getSettingsFile);
        Tasks.inputProperty((Task)this, "scopeMapping", pExtension::getScopeToConfiguration);
        Tasks.inputProperty((Task)this, "mavenVersion", pExtension::getMavenVersion);
        Tasks.inputProperty((Task)this, "aetherVersion", pExtension::getAetherVersion);
        Tasks.inputProperty((Task)this, "wagonVersion", pExtension::getWagonVersion);
        Tasks.inputFiles((Task)this, pExtension::getMavenClassPath);
    }

    @Input
    public boolean isConvertRepositories() {
        return this.fConvertRepositories;
    }

    public void setConvertRepositories(boolean pConvertRepositories) {
        this.fConvertRepositories = pConvertRepositories;
    }

    @Input
    public boolean isConvertLocalRepository() {
        return this.fConvertLocalRepository;
    }

    public void setConvertLocalRepository(boolean pConvertLocalRepository) {
        this.fConvertLocalRepository = pConvertLocalRepository;
    }

    @Input
    public boolean isConvertDependencies() {
        return this.fConvertDependencies;
    }

    public void setConvertDependencies(boolean pConvertDependencies) {
        this.fConvertDependencies = pConvertDependencies;
    }

    @Input
    public boolean isOverwrite() {
        return this.fOverwrite;
    }

    public void setOverwrite(boolean pOverwrite) {
        this.fOverwrite = pOverwrite;
    }

    @InputFile
    public File getPomFile() {
        if (this.fPomFile == null) {
            this.fPomFile = this.getProject().file((Object)"pom.xml");
        }
        return this.fPomFile;
    }

    public void setPomFile(Object pPath) {
        this.fPomFile = pPath != null ? this.getProject().file(pPath) : null;
    }

    @OutputFile
    public File getDestination() {
        if (this.fDestination == null) {
            this.fDestination = new File(this.getPomFile().getParentFile(), "dependencies.gradle");
        }
        return this.fDestination;
    }

    public void setDestination(Object pPath) {
        this.fDestination = pPath != null ? this.getProject().file(pPath) : null;
    }

    @TaskAction
    public void convertPom() {
        File aDestination = this.getDestination();
        if (!aDestination.exists() || this.fOverwrite) {
            PomImporter aImporter = PomImporter.getInstance(this.getProject(), this.getPomFile());
            this.writeDestination(aDestination, this.importRepositories(aImporter), this.importDependencies(aImporter));
        } else {
            this.getLogger().warn("Destination file '{}' exists and overwrite property is false, nothing will be converted", (Object)aDestination.getAbsolutePath());
        }
    }

    private Collection<RepositorySpec> importRepositories(PomImporter pImporter) {
        Collection<RepositorySpec> aRepositories;
        if (!this.fConvertRepositories && !this.fConvertLocalRepository) {
            return Collections.emptyList();
        }
        if (this.fConvertRepositories && this.fConvertLocalRepository) {
            aRepositories = new ArrayList<RepositorySpec>(pImporter.importRepositories());
            aRepositories.add(pImporter.importLocalRepository());
        } else {
            aRepositories = this.fConvertRepositories ? pImporter.importRepositories() : Collections.singletonList(pImporter.importLocalRepository());
        }
        this.getLogger().debug("Imported {} repositories from '{}'", (Object)aRepositories.size(), (Object)pImporter.getPomFile().getAbsolutePath());
        return aRepositories;
    }

    private Collection<DependencySpec> importDependencies(PomImporter pImporter) {
        if (!this.fConvertDependencies) {
            return Collections.emptyList();
        }
        Collection<DependencySpec> aDependencies = pImporter.importDependencies();
        this.getLogger().debug("Imported {} dependencies from '{}'", (Object)aDependencies.size(), (Object)pImporter.getPomFile().getAbsolutePath());
        for (DependencySpec aDependency : aDependencies) {
            String aConfiguration = aDependency.getConfiguration();
            if (this.getProject().getConfigurations().findByName(aConfiguration) != null) continue;
            this.getLogger().warn("The configuration '{}' for dependency '{}' does not exist", (Object)aConfiguration, (Object)aDependency.toDependencyNotation());
        }
        return aDependencies;
    }

    private void writeDestination(File pDestination, Collection<RepositorySpec> pRepositories, Collection<DependencySpec> pDependencies) {
        int aNumEntities = pRepositories.size() + pDependencies.size();
        if (aNumEntities > 0) {
            Projects.ensureParentExists(pDestination);
            this.getLogger().debug("Writing imported entities to '{}'", (Object)pDestination.getAbsolutePath());
            try (PrintWriter aWriter = new PrintWriter(pDestination);){
                GradlePrettyPrinter aPrettyPrinter = new GradlePrettyPrinter(aWriter);
                RepositorySpec.prettyPrintRepositories(aPrettyPrinter, pRepositories);
                DependencySpec.prettyPrintDependencies(aPrettyPrinter, pDependencies);
            }
            catch (IOException ioe) {
                this.getLogger().error("Could not write to file '{}'", (Object)pDestination.getAbsolutePath(), (Object)ioe);
            }
        } else {
            this.getLogger().warn("Nothing converted and written to '{}'", (Object)pDestination.getAbsolutePath());
        }
    }
}

