/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.maven;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.file.FileCollection;
import org.myire.quill.common.ProjectAware;
import org.myire.quill.common.Resolver;

public class MavenImportExtension
extends ProjectAware {
    static final String EXTENSION_NAME = "mavenImport";
    private static final String DEFAULT_MAVEN_VERSION = "3.6.1";
    private static final String DEFAULT_AETHER_VERSION = "1.1.0";
    private static final String DEFAULT_WAGON_VERSION = "3.3.2";
    private static final Resolver<ArtifactRepository> cResolver = new Resolver<ArtifactRepository>(ArtifactRepository.class);
    private final Configuration fConfiguration;
    private File fMavenSettingsFile;
    private String fMavenVersion = "3.6.1";
    private String fAetherVersion = "1.1.0";
    private String fWagonVersion = "3.3.2";
    private FileCollection fMavenClassPath;
    private Object fDefaultRepository;
    private final Map<String, String> fScopeToConfiguration = MavenImportExtension.defaultScopeToConfiguration();
    private final Set<Configuration> fMavenClassPathConfigurations = new HashSet<Configuration>();
    private final Map<Configuration, ArtifactRepository> fInstalledRepositories = new HashMap<Configuration, ArtifactRepository>();

    public MavenImportExtension(Project pProject, Configuration pConfiguration) {
        super(pProject);
        this.fConfiguration = Objects.requireNonNull(pConfiguration);
        this.fMavenClassPath = this.fConfiguration;
        this.maybeAddResolveActions(pConfiguration);
        this.fDefaultRepository = this::getMavenCentralRepository;
    }

    public File getSettingsFile() {
        return this.fMavenSettingsFile;
    }

    public void setSettingsFile(Object pFile) {
        this.fMavenSettingsFile = pFile != null ? this.getProject().file(pFile) : null;
    }

    public String getMavenVersion() {
        return this.fMavenVersion;
    }

    public void setMavenVersion(String pMavenVersion) {
        this.fMavenVersion = pMavenVersion != null ? pMavenVersion : DEFAULT_MAVEN_VERSION;
    }

    public String getAetherVersion() {
        return this.fAetherVersion;
    }

    public void setAetherVersion(String pAetherVersion) {
        this.fAetherVersion = pAetherVersion != null ? pAetherVersion : DEFAULT_AETHER_VERSION;
    }

    public String getWagonVersion() {
        return this.fWagonVersion;
    }

    public void setWagonVersion(String pWagonVersion) {
        this.fWagonVersion = pWagonVersion != null ? pWagonVersion : DEFAULT_WAGON_VERSION;
    }

    public FileCollection getMavenClassPath() {
        return this.fMavenClassPath;
    }

    public void setMavenClassPath(FileCollection pMavenClassPath) {
        Object object = this.fMavenClassPath = pMavenClassPath != null ? pMavenClassPath : this.fConfiguration;
        if (pMavenClassPath instanceof Configuration) {
            this.maybeAddResolveActions((Configuration)pMavenClassPath);
        }
    }

    public ArtifactRepository getClassPathRepository() {
        ArtifactRepository aRepository = cResolver.resolve(this.fDefaultRepository);
        this.fDefaultRepository = aRepository;
        return aRepository;
    }

    public void setClassPathRepository(Object pRepository) {
        this.fDefaultRepository = pRepository;
    }

    public Map<String, String> getScopeToConfiguration() {
        return this.fScopeToConfiguration;
    }

    private ArtifactRepository getMavenCentralRepository() {
        return this.getProject().getRepositories().mavenCentral();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAddResolveActions(Configuration pConfiguration) {
        Set<Configuration> set = this.fMavenClassPathConfigurations;
        synchronized (set) {
            if (this.fMavenClassPathConfigurations.add(pConfiguration)) {
                pConfiguration.getIncoming().beforeResolve(d -> this.installClassPathRepositoryIntoProject(pConfiguration));
                pConfiguration.getIncoming().afterResolve(d -> this.removeClassPathRepositoryFromProject(pConfiguration));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installClassPathRepositoryIntoProject(Configuration pConfiguration) {
        Map<Configuration, ArtifactRepository> map = this.fInstalledRepositories;
        synchronized (map) {
            RepositoryHandler aRepositories = this.getProject().getRepositories();
            if (aRepositories.isEmpty()) {
                ArtifactRepository aReplaced;
                ArtifactRepository aRepo = this.getClassPathRepository();
                if (aRepo != null && !aRepositories.contains((Object)aRepo)) {
                    aRepositories.add(aRepo);
                }
                if ((aReplaced = this.fInstalledRepositories.put(pConfiguration, aRepo)) != null) {
                    aRepositories.remove((Object)aReplaced);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClassPathRepositoryFromProject(Configuration pConfiguration) {
        Map<Configuration, ArtifactRepository> map = this.fInstalledRepositories;
        synchronized (map) {
            ArtifactRepository aRepo = this.fInstalledRepositories.remove(pConfiguration);
            if (aRepo != null) {
                this.getProject().getRepositories().remove((Object)aRepo);
            }
        }
    }

    private static Map<String, String> defaultScopeToConfiguration() {
        HashMap<String, String> aScopeToConfiguration = new HashMap<String, String>();
        aScopeToConfiguration.put("test", "testCompile");
        aScopeToConfiguration.put("provided", "compileOnly");
        return aScopeToConfiguration;
    }
}

