/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.jacoco;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.plugins.JacocoPluginExtension;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.gradle.testing.jacoco.tasks.JacocoReport;
import org.gradle.testing.jacoco.tasks.JacocoReportsContainer;
import org.gradle.util.VersionNumber;
import org.myire.quill.common.Projects;

public class JacocoAdditionsPlugin
implements Plugin<Project> {
    private static final String DEFAULT_TOOL_VERSION = "0.8.4";
    private static final String JACOCO_TEST_REPORT_TASK_NAME = "jacocoTestReport";

    public void apply(Project pProject) {
        pProject.getPlugins().apply(JavaPlugin.class);
        pProject.getPlugins().apply(JacocoPlugin.class);
        this.configureExtension(pProject);
        this.configureReportTask(pProject);
        pProject.getTasks().withType(Test.class, this::configureJacocoTestExtension);
    }

    private void configureExtension(Project pProject) {
        JacocoPluginExtension aExtension = Projects.getExtension(pProject, "jacoco", JacocoPluginExtension.class);
        if (aExtension != null) {
            aExtension.setToolVersion(DEFAULT_TOOL_VERSION);
        }
    }

    private void configureReportTask(Project pProject) {
        JacocoReport aTask = Projects.getTask(pProject, JACOCO_TEST_REPORT_TASK_NAME, JacocoReport.class);
        if (aTask != null) {
            JacocoReportsContainer aReports = aTask.getReports();
            aReports.getXml().setEnabled(true);
            aReports.getHtml().setEnabled(true);
            aReports.getCsv().setEnabled(false);
            Task aBuildTask = Projects.getTask(pProject, "build", Task.class);
            if (aBuildTask != null) {
                aBuildTask.dependsOn(new Object[]{aTask});
            }
        }
    }

    private void configureJacocoTestExtension(Test pTestTask) {
        VersionNumber aGradleVersion;
        Object aExtension = pTestTask.getExtensions().findByName("jacoco");
        if (aExtension instanceof JacocoTaskExtension && (aGradleVersion = VersionNumber.parse((String)pTestTask.getProject().getGradle().getGradleVersion())).compareTo(VersionNumber.version((int)5)) < 0) {
            ((JacocoTaskExtension)aExtension).setAppend(false);
        }
    }
}

