/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.ivy.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.util.DefaultMessageLogger;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.myire.quill.configuration.ConfigurationSpec;
import org.myire.quill.dependency.ModuleDependencySpec;
import org.myire.quill.ivy.IvyModuleLoader;

public class IvyModuleLoaderImpl
implements IvyModuleLoader {
    private File fIvyModuleFile = new File("ivy.xml");
    private File fIvySettingsFile;
    private ModuleDescriptor fIvyModuleDescriptor;
    private String fClassifierExtraAttribute;
    private final Logger fLogger = Logging.getLogger(IvyModuleLoaderImpl.class);

    @Override
    public void init(File pIvyModuleFile, File pIvySettingsFile) {
        this.fIvyModuleFile = Objects.requireNonNull(pIvyModuleFile);
        this.fIvySettingsFile = pIvySettingsFile;
    }

    @Override
    public Collection<ModuleDependencySpec> getDependencies() {
        ModuleDescriptor aModuleDescriptor = this.maybeLoadModuleDescriptor();
        ArrayList<ModuleDependencySpec> aDependencies = new ArrayList<ModuleDependencySpec>();
        for (DependencyDescriptor aIvyDependency : aModuleDescriptor.getDependencies()) {
            for (String aConfiguration : aIvyDependency.getModuleConfigurations()) {
                ModuleDependencySpec aDependencySpec = IvyModuleLoaderImpl.toDependencySpec(aIvyDependency, aConfiguration, this.fClassifierExtraAttribute);
                for (DependencyArtifactDescriptor dependencyArtifactDescriptor : aIvyDependency.getAllDependencyArtifacts()) {
                    IvyModuleLoaderImpl.addDependencyArtifact(aDependencySpec, dependencyArtifactDescriptor);
                }
                for (DependencyArtifactDescriptor dependencyArtifactDescriptor : aIvyDependency.getAllExcludeRules()) {
                    IvyModuleLoaderImpl.addExclusion(aDependencySpec, (ExcludeRule)dependencyArtifactDescriptor);
                }
                aDependencies.add(aDependencySpec);
            }
        }
        return aDependencies;
    }

    @Override
    public Collection<ConfigurationSpec> getConfigurations() {
        ModuleDescriptor aModuleDescriptor = this.maybeLoadModuleDescriptor();
        ArrayList<ConfigurationSpec> aConfigurations = new ArrayList<ConfigurationSpec>();
        for (Configuration aIvyConfiguration : aModuleDescriptor.getConfigurations()) {
            if ("default".equals(aIvyConfiguration.getName())) continue;
            ConfigurationSpec aConfigurationSpec = new ConfigurationSpec(aIvyConfiguration.getName());
            aConfigurationSpec.setTransitive(aIvyConfiguration.isTransitive());
            aConfigurationSpec.setVisible(aIvyConfiguration.getVisibility() == Configuration.Visibility.PUBLIC);
            aConfigurationSpec.setDescription(aIvyConfiguration.getDescription());
            for (String aParent : aIvyConfiguration.getExtends()) {
                aConfigurationSpec.addExtendedConfiguration(aParent);
            }
            aConfigurations.add(aConfigurationSpec);
        }
        return aConfigurations;
    }

    @Override
    public String getOrganisation() {
        return this.maybeLoadModuleDescriptor().getModuleRevisionId().getOrganisation();
    }

    @Override
    public String getModuleName() {
        return this.maybeLoadModuleDescriptor().getModuleRevisionId().getName();
    }

    @Override
    public String getRevision() {
        return this.maybeLoadModuleDescriptor().getModuleRevisionId().getRevision();
    }

    private ModuleDescriptor maybeLoadModuleDescriptor() {
        if (this.fIvyModuleDescriptor != null) {
            return this.fIvyModuleDescriptor;
        }
        try {
            this.fLogger.debug("Loading Ivy module file {}", (Object)this.fIvyModuleFile);
            XmlModuleDescriptorParser aParser = XmlModuleDescriptorParser.getInstance();
            this.fIvyModuleDescriptor = aParser.parseDescriptor((ParserSettings)this.createSettings(), this.fIvyModuleFile.toURI().toURL(), false);
            String aMavenNameSpaceLabel = IvyModuleLoaderImpl.getMavenNameSpaceLabel(this.fIvyModuleDescriptor);
            if (aMavenNameSpaceLabel != null) {
                this.fClassifierExtraAttribute = aMavenNameSpaceLabel + ":classifier";
            }
            return this.fIvyModuleDescriptor;
        }
        catch (IOException | ParseException e) {
            throw new GradleException("Could not load the Ivy module file " + this.fIvyModuleFile, (Throwable)e);
        }
    }

    private IvySettings createSettings() {
        IvySettings aIvySettings = new IvySettings();
        if (!this.loadSettingsFile(aIvySettings)) {
            this.initWithDefaults(aIvySettings);
        }
        return aIvySettings;
    }

    private boolean loadSettingsFile(IvySettings pIvySettings) {
        if (this.fIvySettingsFile == null) {
            return false;
        }
        try {
            this.fLogger.debug("Loading Ivy settings file {}", (Object)this.fIvySettingsFile);
            pIvySettings.load(this.fIvySettingsFile);
            return true;
        }
        catch (IOException | ParseException e) {
            this.fLogger.warn("Could not load the Ivy settings file {} ({})", (Object)this.fIvySettingsFile, (Object)e.getMessage());
            return false;
        }
    }

    private void initWithDefaults(IvySettings pIvySettings) {
        try {
            this.fLogger.debug("Initializing Ivy settings with default values");
            pIvySettings.defaultInit();
        }
        catch (IOException e) {
            this.fLogger.warn("Could not create default Ivy settings, will try to use empty settings ({})", (Object)e.getMessage());
        }
    }

    private static String getMavenNameSpaceLabel(ModuleDescriptor pModuleDescriptor) {
        for (Map.Entry aEntry : pModuleDescriptor.getExtraAttributesNamespaces().entrySet()) {
            if (!((String)aEntry.getValue()).endsWith("/ivy/maven")) continue;
            return (String)aEntry.getKey();
        }
        return null;
    }

    private static ModuleDependencySpec toDependencySpec(DependencyDescriptor pIvyDependency, String pConfiguration, String pClassifierExtraAttribute) {
        Object aClassifier;
        ModuleDependencySpec aDependencySpec = new ModuleDependencySpec(pConfiguration, pIvyDependency.getDependencyRevisionId().getOrganisation(), pIvyDependency.getDependencyRevisionId().getName(), pIvyDependency.getDependencyRevisionId().getRevision());
        aDependencySpec.setTransitive(pIvyDependency.isTransitive());
        aDependencySpec.setChanging(pIvyDependency.isChanging());
        aDependencySpec.setForce(pIvyDependency.isForce());
        if (pClassifierExtraAttribute != null && (aClassifier = pIvyDependency.getQualifiedExtraAttributes().get(pClassifierExtraAttribute)) != null) {
            aDependencySpec.setClassifier(aClassifier.toString());
        }
        return aDependencySpec;
    }

    private static void addDependencyArtifact(ModuleDependencySpec pDependencySpec, DependencyArtifactDescriptor pIvyArtifact) {
        URL aURL = pIvyArtifact.getUrl();
        pDependencySpec.addArtifact(pIvyArtifact.getName(), pIvyArtifact.getType(), pIvyArtifact.getExt(), null, aURL != null ? aURL.toString() : null);
    }

    private static void addExclusion(ModuleDependencySpec pDependencySpec, ExcludeRule pExcludeRule) {
        pDependencySpec.addExclusion(pExcludeRule.getAttribute("organisation"), pExcludeRule.getAttribute("module"));
    }

    static {
        Message.setDefaultLogger((MessageLogger)new DefaultMessageLogger(1));
    }
}

