/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.ivy;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.Project;
import org.myire.quill.common.ExternalToolLoader;
import org.myire.quill.common.ProjectAware;
import org.myire.quill.common.Projects;
import org.myire.quill.configuration.ConfigurationSpec;
import org.myire.quill.dependency.DependencySpec;
import org.myire.quill.dependency.ModuleDependencySpec;
import org.myire.quill.ivy.IvyImportExtension;
import org.myire.quill.ivy.IvyModuleLoader;

public class IvyFileImporter
extends ProjectAware {
    private static final String IMPLEMENTATION_PACKAGE = "org.myire.quill.ivy.impl";
    private static final String IMPLEMENTATION_CLASS = "IvyModuleLoaderImpl";
    private static final Map<File, IvyFileImporter> cCache = new HashMap<File, IvyFileImporter>();
    private final File fIvyFile;
    private final IvyImportExtension fExtension;
    private IvyModuleLoader fIvyModuleLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IvyFileImporter getInstance(Project pProject, File pIvyFile) {
        Map<File, IvyFileImporter> map = cCache;
        synchronized (map) {
            return cCache.computeIfAbsent(pIvyFile, f -> new IvyFileImporter(pProject, (File)f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearInstanceCache() {
        Map<File, IvyFileImporter> map = cCache;
        synchronized (map) {
            cCache.clear();
        }
    }

    private IvyFileImporter(Project pProject, File pIvyFile) {
        super(pProject);
        this.fIvyFile = Objects.requireNonNull(pIvyFile);
        this.fExtension = Projects.getExtension(pProject, "ivyImport", IvyImportExtension.class);
    }

    File getIvyFile() {
        return this.fIvyFile;
    }

    Collection<ConfigurationSpec> importConfigurations() {
        return this.maybeCreateIvyLoader().getConfigurations();
    }

    Collection<ModuleDependencySpec> importDependencies() {
        Collection<ModuleDependencySpec> aDependencies = this.maybeCreateIvyLoader().getDependencies();
        aDependencies.forEach(this::replaceWildcardConfiguration);
        return aDependencies;
    }

    String getOrganisation() {
        return this.maybeCreateIvyLoader().getOrganisation();
    }

    String getRevision() {
        return this.maybeCreateIvyLoader().getRevision();
    }

    private void replaceWildcardConfiguration(DependencySpec pDependency) {
        if ("*".equals(pDependency.getConfiguration())) {
            pDependency.setConfiguration(this.fExtension.getWildcardConfiguration());
        }
    }

    private IvyModuleLoader maybeCreateIvyLoader() {
        if (this.fIvyModuleLoader == null) {
            this.fIvyModuleLoader = this.createIvyModuleLoader();
            this.fIvyModuleLoader.init(this.fIvyFile, this.fExtension != null ? this.fExtension.getSettingsFile() : null);
        }
        return this.fIvyModuleLoader;
    }

    private IvyModuleLoader createIvyModuleLoader() {
        try {
            ExternalToolLoader<IvyModuleLoader> aLoader = new ExternalToolLoader<IvyModuleLoader>(IvyModuleLoader.class, IMPLEMENTATION_PACKAGE, IMPLEMENTATION_CLASS, this.fExtension::getIvyClassPath);
            return aLoader.createToolProxy();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.getProjectLogger().error("Could not create an instance of '{}.{}'", new Object[]{IMPLEMENTATION_PACKAGE, IMPLEMENTATION_CLASS, e});
            return EmptyIvyModuleLoader.INSTANCE;
        }
    }

    private static class EmptyIvyModuleLoader
    implements IvyModuleLoader {
        static final IvyModuleLoader INSTANCE = new EmptyIvyModuleLoader();

        private EmptyIvyModuleLoader() {
        }

        @Override
        public void init(File pIvyModuleFile, File pIvySettingsFile) {
        }

        @Override
        public Collection<ModuleDependencySpec> getDependencies() {
            return Collections.emptyList();
        }

        @Override
        public Collection<ConfigurationSpec> getConfigurations() {
            return Collections.emptyList();
        }

        @Override
        public String getOrganisation() {
            return "";
        }

        @Override
        public String getModuleName() {
            return "";
        }

        @Override
        public String getRevision() {
            return "";
        }
    }
}

