/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.ivy;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.myire.quill.common.GradlePrettyPrinter;
import org.myire.quill.common.Projects;
import org.myire.quill.common.Tasks;
import org.myire.quill.configuration.ConfigurationSpec;
import org.myire.quill.dependency.DependencySpec;
import org.myire.quill.dependency.ModuleDependencySpec;
import org.myire.quill.ivy.IvyFileImporter;
import org.myire.quill.ivy.IvyImportExtension;

public class IvyFileConvertTask
extends DefaultTask {
    static final String TASK_NAME = "convertIvyModule";
    private static final String TASK_DESCRIPTION = "Imports configurations and/or dependencies from an Ivy module file and writes them to a Gradle file";
    private File fIvyFile;
    private File fDestination;
    private boolean fConvertConfigurations = true;
    private boolean fConvertDependencies = true;
    private boolean fOverwrite = true;

    void init(IvyImportExtension pExtension) {
        this.setDescription(TASK_DESCRIPTION);
        this.onlyIf(ignore -> this.fConvertConfigurations || this.fConvertDependencies);
        Tasks.optionalInputFile((Task)this, pExtension::getSettingsFile);
        Tasks.inputProperty((Task)this, "ivyVersion", pExtension::getIvyVersion);
        Tasks.inputFiles((Task)this, pExtension::getIvyClassPath);
    }

    @Input
    public boolean isConvertConfigurations() {
        return this.fConvertConfigurations;
    }

    public void setConvertConfigurations(boolean pConvertConfigurations) {
        this.fConvertConfigurations = pConvertConfigurations;
    }

    @Input
    public boolean isConvertDependencies() {
        return this.fConvertDependencies;
    }

    public void setConvertDependencies(boolean pConvertDependencies) {
        this.fConvertDependencies = pConvertDependencies;
    }

    @Input
    public boolean isOverwrite() {
        return this.fOverwrite;
    }

    public void setOverwrite(boolean pOverwrite) {
        this.fOverwrite = pOverwrite;
    }

    @InputFile
    public File getIvyFile() {
        if (this.fIvyFile == null) {
            this.fIvyFile = this.getProject().file((Object)"ivy.xml");
        }
        return this.fIvyFile;
    }

    public void setIvyFile(Object pPath) {
        this.fIvyFile = pPath != null ? this.getProject().file(pPath) : null;
    }

    @OutputFile
    public File getDestination() {
        if (this.fDestination == null) {
            this.fDestination = new File(this.getIvyFile().getParentFile(), "dependencies.gradle");
        }
        return this.fDestination;
    }

    public void setDestination(Object pPath) {
        this.fDestination = pPath != null ? this.getProject().file(pPath) : null;
    }

    @TaskAction
    public void convertIvyFile() {
        File aDestination = this.getDestination();
        if (!aDestination.exists() || this.fOverwrite) {
            IvyFileImporter aImporter = IvyFileImporter.getInstance(this.getProject(), this.getIvyFile());
            this.writeDestination(aDestination, this.importConfigurations(aImporter), this.importDependencies(aImporter));
        } else {
            this.getLogger().warn("Destination file '{}' exists and overwrite property is false, nothing will be converted", (Object)aDestination.getAbsolutePath());
        }
    }

    private Collection<ConfigurationSpec> importConfigurations(IvyFileImporter pImporter) {
        if (this.fConvertConfigurations) {
            Collection<ConfigurationSpec> aConfigurations = pImporter.importConfigurations();
            this.getLogger().debug("Imported {} configurations from '{}'", (Object)aConfigurations.size(), (Object)pImporter.getIvyFile().getAbsolutePath());
            return aConfigurations;
        }
        return Collections.emptyList();
    }

    private Collection<ModuleDependencySpec> importDependencies(IvyFileImporter pImporter) {
        if (this.fConvertDependencies) {
            Collection<ModuleDependencySpec> aDependencies = pImporter.importDependencies();
            this.getLogger().debug("Imported {} dependencies from '{}'", (Object)aDependencies.size(), (Object)pImporter.getIvyFile().getAbsolutePath());
            return aDependencies;
        }
        return Collections.emptyList();
    }

    private void writeDestination(File pDestination, Collection<ConfigurationSpec> pConfigurations, Collection<ModuleDependencySpec> pDependencies) {
        int aNumEntities = pConfigurations.size() + pDependencies.size();
        if (aNumEntities > 0) {
            Projects.ensureParentExists(pDestination);
            this.getLogger().debug("Writing imported entities to '{}'", (Object)pDestination.getAbsolutePath());
            try (PrintWriter aWriter = new PrintWriter(pDestination);){
                GradlePrettyPrinter aPrettyPrinter = new GradlePrettyPrinter(aWriter);
                ConfigurationSpec.prettyPrintConfigurations(aPrettyPrinter, pConfigurations);
                DependencySpec.prettyPrintDependencies(aPrettyPrinter, pDependencies);
            }
            catch (IOException ioe) {
                this.getLogger().error("Could not write to file '{}'", (Object)pDestination.getAbsolutePath(), (Object)ioe);
            }
        } else {
            this.getLogger().warn("Nothing converted and written to '{}'", (Object)pDestination.getAbsolutePath());
        }
    }
}

