/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.dependency;

import java.util.Objects;
import org.gradle.api.Project;
import org.myire.quill.common.GradlePrettyPrinter;
import org.myire.quill.dependency.Dependencies;
import org.myire.quill.dependency.DependencySpec;

public class ModuleDependencySpec
extends DependencySpec {
    private static final String ATTRIBUTE_CHANGING = "changing";
    private static final String ATTRIBUTE_FORCE = "force";
    private final String fGroup;
    private final String fName;
    private final String fVersion;
    private String fClassifier;
    private String fExtension;
    private boolean fChanging;
    private boolean fForce;

    public ModuleDependencySpec(String pConfiguration, String pGroup, String pName, String pVersion) {
        super(pConfiguration);
        this.fGroup = pGroup;
        this.fName = Objects.requireNonNull(pName);
        this.fVersion = pVersion;
    }

    public String getGroup() {
        return this.fGroup;
    }

    public String getName() {
        return this.fName;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public String getClassifier() {
        return this.fClassifier;
    }

    public void setClassifier(String pClassifier) {
        this.fClassifier = pClassifier;
    }

    public String getExtension() {
        return this.fExtension;
    }

    public void setExtension(String pExtension) {
        this.fExtension = pExtension;
    }

    public boolean isChanging() {
        return this.fChanging;
    }

    public void setChanging(boolean pChanging) {
        this.fChanging = pChanging;
    }

    public boolean isForce() {
        return this.fForce;
    }

    public void setForce(boolean pForce) {
        this.fForce = pForce;
    }

    @Override
    public String toDependencyNotation() {
        StringBuilder aNotation = new StringBuilder(256);
        if (this.fGroup != null) {
            aNotation.append(this.fGroup).append(':');
        }
        aNotation.append(this.fName);
        if (this.fVersion != null) {
            aNotation.append(':').append(this.fVersion);
        }
        if (this.fClassifier != null) {
            aNotation.append(':').append(this.fClassifier);
        }
        if (this.fExtension != null) {
            aNotation.append('@').append(this.fExtension);
        }
        return aNotation.toString();
    }

    @Override
    public boolean addTo(Project pProject) {
        return Dependencies.addDependency(pProject, this);
    }

    @Override
    public void prettyPrint(GradlePrettyPrinter pPrinter) {
        if (this.hasNonDefaultAttribute()) {
            pPrinter.printMethodCall(this.getConfiguration(), this.toDependencyNotation(), true, true);
            pPrinter.printClosure(null, this::printClosureBody);
        } else {
            pPrinter.printMethodCall(this.getConfiguration(), this.toDependencyNotation(), true, false);
        }
    }

    @Override
    protected boolean hasNonDefaultAttribute() {
        return super.hasNonDefaultAttribute() || this.fChanging || this.fForce;
    }

    @Override
    protected void printClosureBody(GradlePrettyPrinter pPrinter) {
        if (this.fChanging) {
            pPrinter.printAttribute(ATTRIBUTE_CHANGING, this.fChanging);
        }
        if (this.fForce) {
            pPrinter.printAttribute(ATTRIBUTE_FORCE, this.fForce);
        }
        super.printClosureBody(pPrinter);
    }

    boolean matches(String pGroup, String pName, String pVersion) {
        return this.fName.equals(pName) && Objects.equals(this.fGroup, pGroup) && Objects.equals(this.fVersion, pVersion);
    }
}

