/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.dependency;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.myire.quill.common.GradlePrettyPrinter;
import org.myire.quill.common.PrettyPrintable;

public class ExclusionSpec
implements PrettyPrintable {
    private static final String KEY_EXCLUDE = "exclude";
    private static final String ATTRIBUTE_GROUP = "group";
    private static final String ATTRIBUTE_MODULE = "module";
    private final String fGroup;
    private final String fModule;

    ExclusionSpec(String pGroup, String pModule) {
        if (pGroup == null) {
            Objects.requireNonNull(pModule);
        }
        this.fGroup = pGroup;
        this.fModule = pModule;
    }

    public String getGroup() {
        return this.fGroup;
    }

    public String getModule() {
        return this.fModule;
    }

    Map<String, String> toMap() {
        if (this.fGroup != null) {
            if (this.fModule != null) {
                LinkedHashMap<String, String> aMap = new LinkedHashMap<String, String>();
                aMap.put(ATTRIBUTE_GROUP, this.fGroup);
                aMap.put(ATTRIBUTE_MODULE, this.fModule);
                return aMap;
            }
            return Collections.singletonMap(ATTRIBUTE_GROUP, this.fGroup);
        }
        return Collections.singletonMap(ATTRIBUTE_MODULE, this.fModule);
    }

    @Override
    public void prettyPrint(GradlePrettyPrinter pPrinter) {
        pPrinter.printMethodCall(KEY_EXCLUDE, this.toMapNotation(), false, false);
    }

    private String toMapNotation() {
        if (this.fGroup != null) {
            if (this.fModule != null) {
                return "group: " + PrettyPrintable.quote(this.fGroup) + ", " + ATTRIBUTE_MODULE + ": " + PrettyPrintable.quote(this.fModule);
            }
            return "group: " + PrettyPrintable.quote(this.fGroup);
        }
        return "module: " + PrettyPrintable.quote(this.fModule);
    }
}

