/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.cpd.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.function.Consumer;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.CSVWithLinecountPerFileRenderer;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.VSRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.cpd.renderer.CPDRenderer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.myire.quill.cpd.CpdParameters;
import org.myire.quill.cpd.CpdRunner;

public class CpdRunnerImpl
implements CpdRunner {
    private final Logger fLogger = Logging.getLogger(CpdRunnerImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runCpd(Collection<File> pFiles, File pReportFile, String pReportFormat, CpdParameters pParameters) throws IOException {
        ClassLoader aContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Language.class.getClassLoader());
        CPDConfiguration aConfiguration = this.toConfiguration(pParameters);
        CPD aCpd = new CPD(aConfiguration);
        this.fLogger.debug("Tokenizing files for copy-paste analysis");
        for (File aFile : pFiles) {
            aCpd.add(aFile);
        }
        this.fLogger.debug("Performing copy-paste analysis");
        aCpd.go();
        try (OutputStreamWriter aWriter = this.createReportWriter(pReportFile, aConfiguration.getEncoding());){
            this.fLogger.debug("Writing copy-paste analysis report to {}", (Object)pReportFile.getAbsolutePath());
            this.createRenderer(pReportFormat).render(aCpd.getMatches(), (Writer)aWriter);
        }
        finally {
            Thread.currentThread().setContextClassLoader(aContextClassLoader);
        }
    }

    private OutputStreamWriter createReportWriter(File pReportFile, String pEncoding) throws IOException {
        if (pEncoding != null) {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(pReportFile), pEncoding);
        }
        return new OutputStreamWriter(new FileOutputStream(pReportFile));
    }

    private CPDRenderer createRenderer(String pReportFormat) {
        switch (pReportFormat) {
            case "xml": {
                return new XMLRenderer();
            }
            case "text": {
                return new SimpleRenderer();
            }
            case "csv": {
                return new CSVRenderer();
            }
            case "csv_with_linecount_per_file": {
                return new CSVWithLinecountPerFileRenderer();
            }
            case "vs": {
                return new VSRenderer();
            }
        }
        this.fLogger.warn("Unsupported report format {}, falling back to XML", (Object)pReportFormat);
        return new XMLRenderer();
    }

    private CPDConfiguration toConfiguration(CpdParameters pParameters) {
        CPDConfiguration aConfiguration = new CPDConfiguration();
        aConfiguration.setFailOnViolation(false);
        this.consumeIfNonNull(arg_0 -> ((CPDConfiguration)aConfiguration).setEncoding(arg_0), pParameters.getEncoding());
        aConfiguration.setMinimumTileSize(pParameters.getMinimumTokenCount());
        aConfiguration.setIgnoreLiterals(pParameters.isIgnoreLiterals());
        aConfiguration.setIgnoreIdentifiers(pParameters.isIgnoreIdentifiers());
        aConfiguration.setIgnoreAnnotations(pParameters.isIgnoreAnnotations());
        aConfiguration.setIgnoreUsings(pParameters.isIgnoreUsings());
        aConfiguration.setSkipDuplicates(pParameters.isSkipDuplicateFiles());
        aConfiguration.setSkipLexicalErrors(pParameters.isSkipLexicalErrors());
        aConfiguration.setNoSkipBlocks(!pParameters.isSkipBlocks());
        this.consumeIfNonNull(arg_0 -> ((CPDConfiguration)aConfiguration).setSkipBlocksPattern(arg_0), pParameters.getSkipBlocksPattern());
        this.setLanguage(aConfiguration, pParameters.getLanguage());
        return aConfiguration;
    }

    private void setLanguage(CPDConfiguration pConfiguration, String pLanguage) {
        if (pLanguage == null) {
            pLanguage = "java";
        }
        pConfiguration.setLanguage(CPDConfiguration.getLanguageFromString((String)pLanguage));
        CPDConfiguration.setSystemProperties((CPDConfiguration)pConfiguration);
    }

    private void consumeIfNonNull(Consumer<String> pSetter, String pValue) {
        if (pValue != null) {
            pSetter.accept(pValue);
        }
    }
}

