/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.common;

import java.util.Objects;
import java.util.function.Supplier;
import org.gradle.api.file.FileCollection;
import org.myire.quill.common.ExternalToolProxyClassLoader;

public class ExternalToolLoader<T> {
    private final Class<T> fProxyClass;
    private final ExternalToolProxyClassLoader fToolClassLoader;
    private final String fProxyImplementationFqn;
    private Class<?> fProxyImplementationClass;

    public ExternalToolLoader(Class<T> pProxyClass, String pProxyImplementationPackage, String pProxyImplementationClass, Supplier<FileCollection> pToolClassPathSource) {
        this.fProxyClass = Objects.requireNonNull(pProxyClass);
        this.fToolClassLoader = new ExternalToolProxyClassLoader(pToolClassPathSource, s -> s.startsWith(pProxyImplementationPackage), this.fProxyClass.getClassLoader());
        StringBuilder aBuilder = new StringBuilder(pProxyImplementationPackage);
        if (!pProxyImplementationPackage.endsWith(".")) {
            aBuilder.append('.');
        }
        aBuilder.append(Objects.requireNonNull(pProxyImplementationClass));
        this.fProxyImplementationFqn = aBuilder.toString();
    }

    public T createToolProxy() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (this.fProxyImplementationClass == null) {
            this.fProxyImplementationClass = Class.forName(this.fProxyImplementationFqn, false, this.fToolClassLoader);
        }
        Object aProxy = this.fProxyImplementationClass.newInstance();
        return this.fProxyClass.cast(aProxy);
    }
}

