/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.cobertura;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.util.ConfigureUtil;
import org.myire.quill.cobertura.CoberturaReports;
import org.myire.quill.cobertura.CoberturaReportsTask;
import org.myire.quill.common.Projects;
import org.myire.quill.report.DefaultDirectoryReport;
import org.myire.quill.report.DefaultSingleFileReport;

public class CoberturaReportsImpl
implements CoberturaReports {
    private static final String XML_REPORT_NAME = "coberturaXml";
    private static final String HTML_REPORT_NAME = "coberturaHtml";
    private static final String DEFAULT_XML_REPORT_FILE_NAME = "coverage.xml";
    private final SingleFileReport fXmlReport;
    private final DirectoryReport fHtmlReport;

    CoberturaReportsImpl(CoberturaReportsTask pTask) {
        String aReportDirName = pTask.getContext().getName();
        this.fXmlReport = new DefaultSingleFileReport(pTask.getProject(), XML_REPORT_NAME, "Cobertura XML report", new DefaultXmlReportFile(pTask.getProject(), aReportDirName, DEFAULT_XML_REPORT_FILE_NAME));
        this.fHtmlReport = new DefaultDirectoryReport(pTask.getProject(), HTML_REPORT_NAME, "Cobertura HTML report", "index.html", (Closure<File>)new DefaultReportsDir(pTask.getProject(), aReportDirName));
        this.fXmlReport.setEnabled(true);
        this.fHtmlReport.setEnabled(true);
    }

    @Override
    public SingleFileReport getXml() {
        return this.fXmlReport;
    }

    @Override
    public DirectoryReport getHtml() {
        return this.fHtmlReport;
    }

    @Override
    public Report getReportByName(String pReportName) {
        if (XML_REPORT_NAME.equalsIgnoreCase(pReportName)) {
            return this.fXmlReport;
        }
        if (HTML_REPORT_NAME.equalsIgnoreCase(pReportName)) {
            return this.fHtmlReport;
        }
        return null;
    }

    public CoberturaReports configure(Closure pClosure) {
        ConfigureUtil.configureSelf((Closure)pClosure, (Object)this);
        return this;
    }

    private static class DefaultXmlReportFile
    extends DefaultReportsDir {
        private final String fFileName;

        DefaultXmlReportFile(Project pProject, String pDirectoryName, String pFileName) {
            super(pProject, pDirectoryName);
            this.fFileName = pFileName;
        }

        @Override
        public File doCall(Object pValue) {
            return new File(this.defaultReportsDir(), this.fFileName);
        }
    }

    private static class DefaultReportsDir
    extends Closure<File> {
        private final Project fProject;
        private final String fDirectoryName;

        DefaultReportsDir(Project pProject, String pDirectoryName) {
            super(null);
            this.fProject = pProject;
            this.fDirectoryName = pDirectoryName;
        }

        public File doCall(Object pValue) {
            return this.defaultReportsDir();
        }

        protected File defaultReportsDir() {
            File aCoberturaRootReportDir = Projects.createReportDirectorySpec(this.fProject, "cobertura");
            return new File(aCoberturaRootReportDir, this.fDirectoryName);
        }
    }
}

