/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.scent;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.reporting.ConfigurableReport;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.reporting.internal.TaskReportContainer;
import org.myire.quill.report.DefaultSingleFileReport;
import org.myire.quill.report.ReportTransformingReport;
import org.myire.quill.report.TransformingReport;
import org.myire.quill.scent.ScentReports;
import org.myire.quill.scent.ScentTask;

public class ScentReportsImpl
extends TaskReportContainer<Report>
implements ScentReports {
    private static final String XML_REPORT_NAME = "scentXml";
    private static final String HTML_REPORT_NAME = "scentHtml";
    private static final String BUILTIN_SCENT_XSL = "/org/myire/quill/rsrc/report/scent/scent.xsl";

    ScentReportsImpl(ScentTask pTask) {
        super(ConfigurableReport.class, (Task)pTask);
        SingleFileReport aXmlReport = (SingleFileReport)this.add(DefaultSingleFileReport.class, new Object[]{pTask.getProject(), XML_REPORT_NAME, "Scent XML report", new DefaultXmlReportDestination(pTask)});
        TransformingReport aHtmlReport = (TransformingReport)this.add(ReportTransformingReport.class, new Object[]{pTask.getProject(), HTML_REPORT_NAME, "Scent HTML report", aXmlReport, BUILTIN_SCENT_XSL});
        aXmlReport.setEnabled(true);
        aHtmlReport.setEnabled(true);
    }

    @Override
    public SingleFileReport getXml() {
        return (SingleFileReport)this.getByName(XML_REPORT_NAME);
    }

    @Override
    public TransformingReport getHtml() {
        return (TransformingReport)this.getByName(HTML_REPORT_NAME);
    }

    private static class DefaultXmlReportDestination
    extends Closure<File> {
        private final ScentTask fTask;

        DefaultXmlReportDestination(ScentTask pTask) {
            super(null);
            this.fTask = pTask;
        }

        public File doCall(Object pValue) {
            return this.fTask.defaultXmlDestination();
        }
    }
}

