/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.javancss;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.reporting.ConfigurableReport;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.internal.TaskReportContainer;
import org.myire.quill.javancss.JavaNcssReports;
import org.myire.quill.javancss.JavaNcssTask;
import org.myire.quill.report.DefaultFormatChoiceReport;
import org.myire.quill.report.FormatChoiceReport;
import org.myire.quill.report.FormatChoiceReportTransformingReport;
import org.myire.quill.report.TransformingReport;

public class JavaNcssReportsImpl
extends TaskReportContainer<Report>
implements JavaNcssReports {
    private static final String PRIMARY_REPORT_NAME = "javancssPrimary";
    private static final String HTML_REPORT_NAME = "javancssHtml";
    private static final String BUILTIN_JAVANCSS_XSL = "/org/myire/quill/rsrc/report/javancss/javancss.xsl";

    JavaNcssReportsImpl(JavaNcssTask pTask) {
        super(ConfigurableReport.class, (Task)pTask);
        DefaultFormatChoiceReport aPrimaryReport = (DefaultFormatChoiceReport)this.add(DefaultFormatChoiceReport.class, new Object[]{pTask, PRIMARY_REPORT_NAME, "JavaNCSS primary report", "xml", new DefaultPrimaryReportDestination(pTask)});
        aPrimaryReport.addLegalFormats("text");
        TransformingReport aHtmlReport = (TransformingReport)this.add(FormatChoiceReportTransformingReport.class, new Object[]{pTask.getProject(), HTML_REPORT_NAME, "JavaNCSS HTML report", aPrimaryReport, BUILTIN_JAVANCSS_XSL});
        aPrimaryReport.setEnabled(true);
        aHtmlReport.setEnabled(true);
    }

    @Override
    public FormatChoiceReport getPrimary() {
        return (FormatChoiceReport)this.getByName(PRIMARY_REPORT_NAME);
    }

    @Override
    public TransformingReport getHtml() {
        return (TransformingReport)this.getByName(HTML_REPORT_NAME);
    }

    private static class DefaultPrimaryReportDestination
    extends Closure<File> {
        private final JavaNcssTask fTask;

        DefaultPrimaryReportDestination(JavaNcssTask pTask) {
            super(null);
            this.fTask = pTask;
        }

        public File doCall(Object pValue) {
            return this.fTask.defaultPrimaryDestination();
        }
    }
}

