/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.cobertura;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.reporting.ConfigurableReport;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.reporting.internal.TaskReportContainer;
import org.myire.quill.cobertura.CoberturaReports;
import org.myire.quill.cobertura.CoberturaReportsTask;
import org.myire.quill.common.Projects;
import org.myire.quill.report.DefaultDirectoryReport;
import org.myire.quill.report.DefaultSingleFileReport;

public class CoberturaReportsImpl
extends TaskReportContainer<Report>
implements CoberturaReports {
    private static final String XML_REPORT_NAME = "coberturaXml";
    private static final String HTML_REPORT_NAME = "coberturaHtml";
    private static final String DEFAULT_XML_REPORT_FILE_NAME = "coverage.xml";

    CoberturaReportsImpl(CoberturaReportsTask pTask) {
        super(ConfigurableReport.class, (Task)pTask);
        String aReportDirName = pTask.getContext().getName();
        SingleFileReport aXmlReport = (SingleFileReport)this.add(DefaultSingleFileReport.class, new Object[]{pTask.getProject(), XML_REPORT_NAME, "Cobertura XML report", new DefaultXmlReportFile(pTask.getProject(), aReportDirName, DEFAULT_XML_REPORT_FILE_NAME)});
        DirectoryReport aHtmlReport = (DirectoryReport)this.add(DefaultDirectoryReport.class, new Object[]{pTask.getProject(), HTML_REPORT_NAME, "Cobertura HTML report", "index.html", new DefaultReportsDir(pTask.getProject(), aReportDirName)});
        aXmlReport.setEnabled(true);
        aHtmlReport.setEnabled(true);
    }

    @Override
    public SingleFileReport getXml() {
        return (SingleFileReport)this.getByName(XML_REPORT_NAME);
    }

    @Override
    public DirectoryReport getHtml() {
        return (DirectoryReport)this.getByName(HTML_REPORT_NAME);
    }

    private static class DefaultXmlReportFile
    extends DefaultReportsDir {
        private final String fFileName;

        DefaultXmlReportFile(Project pProject, String pDirectoryName, String pFileName) {
            super(pProject, pDirectoryName);
            this.fFileName = pFileName;
        }

        @Override
        public File doCall(Object pValue) {
            return new File(this.defaultReportsDir(), this.fFileName);
        }
    }

    private static class DefaultReportsDir
    extends Closure<File> {
        private final Project fProject;
        private final String fDirectoryName;

        DefaultReportsDir(Project pProject, String pDirectoryName) {
            super(null);
            this.fProject = pProject;
            this.fDirectoryName = pDirectoryName;
        }

        public File doCall(Object pValue) {
            return this.defaultReportsDir();
        }

        protected File defaultReportsDir() {
            File aCoberturaRootReportDir = Projects.createReportDirectorySpec(this.fProject, "cobertura");
            return new File(aCoberturaRootReportDir, this.fDirectoryName);
        }
    }
}

