/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.tool.kafka.ops;

import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.zk.KafkaZkClient;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.utils.Time;

public class Clients
implements AutoCloseable {
    public static final String KEY_BOOTSTRAP_SERVERS = "bootstrap.servers";
    public static final String KEY_ZK_CONNECT = KafkaConfig.ZkConnectProp();
    public static final String KEY_CLIENT_ID = "client.id";
    public static final String DEFAULT_CLIENT_ID = "kafka-ops";
    private AdminClient _adminClient;
    private ZooKeeperClient _zkClient;
    private KafkaZkClient _kafkaZkClient;

    public Clients(Properties properties) {
        String clientId = properties.getProperty(KEY_CLIENT_ID);
        if (clientId == null || clientId.isEmpty()) {
            properties.setProperty(KEY_CLIENT_ID, DEFAULT_CLIENT_ID);
        }
        this._adminClient = AdminClient.create((Properties)properties);
        String zkConnect = properties.getProperty(KEY_ZK_CONNECT);
        this._zkClient = new ZooKeeperClient(zkConnect, 30000, 30000, Integer.MAX_VALUE, Time.SYSTEM, DEFAULT_CLIENT_ID, "clients");
        this._kafkaZkClient = new KafkaZkClient(this._zkClient, false, Time.SYSTEM);
    }

    public AdminClient getAdminClient() {
        return this._adminClient;
    }

    public ZooKeeperClient getZkClient() {
        return this._zkClient;
    }

    public KafkaZkClient getKafkaZkClient() {
        return this._kafkaZkClient;
    }

    @Override
    public void close() throws Exception {
        this._adminClient.close();
        this._kafkaZkClient.close();
        this._zkClient.close();
    }
}

