/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.tool.kafka.ops;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mydotey.tool.kafka.ops.Brokers;
import org.mydotey.tool.kafka.ops.KafkaTest;

public class BrokersTest
extends KafkaTest {
    @Test
    public void getAll() throws Exception {
        Brokers brokers = new Brokers(this.getClients());
        Set expected = ALL_BROKERS;
        Set actual = brokers.getAll();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void getTopics() throws Exception {
        Brokers brokers = new Brokers(this.getClients());
        ImmutableSet expected = ImmutableSet.of((Object)"__consumer_offsets", (Object)"test2");
        Set actual = brokers.getTopics(2);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void getTopicPartitons() {
        Brokers brokers = new Brokers(this.getClients());
        ImmutableMap expected = ImmutableMap.of((Object)"test2", (Object)ImmutableSet.of((Object)1, (Object)2, (Object)3));
        Map actual = brokers.getTopicPartitons(2, (Set)ImmutableSet.of((Object)"test2"));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void getAssignments() {
        Brokers brokers = new Brokers(this.getClients());
        ImmutableMap expected = ImmutableMap.of((Object)"test", (Object)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)1), (Object)3, (Object)ImmutableList.of((Object)1), (Object)5, (Object)ImmutableList.of((Object)1), (Object)7, (Object)ImmutableList.of((Object)1), (Object)9, (Object)ImmutableList.of((Object)1)));
        Map actual = brokers.getAssignments(1, (Set)ImmutableSet.of((Object)"test"));
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = ImmutableMap.of((Object)"test2", (Object)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)1, (Object)2), (Object)2, (Object)ImmutableList.of((Object)2, (Object)0), (Object)3, (Object)ImmutableList.of((Object)0, (Object)2)));
        actual = brokers.getAssignments(2, (Set)ImmutableSet.of((Object)"test2"));
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = ImmutableMap.of((Object)"test", (Object)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)1), (Object)3, (Object)ImmutableList.of((Object)1)));
        actual = brokers.getAssignments(1, "test", (Set)ImmutableSet.of((Object)1, (Object)3));
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = ImmutableMap.of((Object)"test2", (Object)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)1, (Object)2), (Object)2, (Object)ImmutableList.of((Object)2, (Object)0)));
        actual = brokers.getAssignments(2, "test2", (Set)ImmutableSet.of((Object)1, (Object)2));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void generateAssignmentsForTransfer() {
        Brokers brokers = new Brokers(this.getClients());
        ImmutableMap expected = ImmutableMap.of((Object)"test", (Object)ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)2), (Object)3, (Object)ImmutableList.of((Object)2), (Object)5, (Object)ImmutableList.of((Object)2), (Object)7, (Object)ImmutableList.of((Object)2), (Object)9, (Object)ImmutableList.of((Object)2)));
        Map actual = brokers.generateAssignmentsForTransfer(1, 2, (Set)ImmutableSet.of((Object)"test"));
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

