/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.tool.kafka.ops;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mydotey.java.io.file.FileExtension;
import org.mydotey.tool.kafka.ops.Assignments;
import org.mydotey.tool.kafka.ops.Brokers;
import org.mydotey.tool.kafka.ops.KafkaTest;
import org.mydotey.tool.kafka.ops.Topics;

public class AssignmentsTest
extends KafkaTest {
    @Test
    public void getAssignments() throws Exception {
        Assignments assignments = new Assignments(this.getClients());
        Topics topics = new Topics(this.getClients());
        Map expected = ALL_ASSIGNMENTS;
        Map actual = assignments.getOfTopics(topics.getAll());
        System.out.println(actual);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = ImmutableMap.of((Object)"__consumer_offsets", (Object)CONSUMER_OFFSETSETS_ASSIGNMENTS);
        actual = assignments.getOfTopics((Set)ImmutableSet.of((Object)"__consumer_offsets"));
        System.out.println(actual);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = ImmutableMap.of((Object)"test", (Object)TOPIC_ASSIGNMENTS);
        actual = assignments.getOfTopics((Set)ImmutableSet.of((Object)"test"));
        System.out.println(actual);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = ImmutableMap.of((Object)"test2", (Object)TOPIC_2_ASSIGNMENTS);
        actual = assignments.getOfTopics((Set)ImmutableSet.of((Object)"test2"));
        System.out.println(actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void toJson() {
        Assignments assignments = new Assignments(this.getClients());
        String jsonString = assignments.toJson(ALL_ASSIGNMENTS);
        System.out.println(jsonString);
    }

    @Test
    public void fromJson() throws IOException, URISyntaxException {
        Assignments assignments = new Assignments(this.getClients());
        URI testFile = new URI(AssignmentsTest.class.getResource("/assignments.json").toString());
        String jsonString = FileExtension.readFileContent((Path)Paths.get(testFile));
        Map assignmentsMap = assignments.fromJson(jsonString);
        System.out.println(assignmentsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void reassignTest() throws InterruptedException {
        Map assignmentsMap;
        Brokers brokers = new Brokers(this.getClients());
        Assignments assignments = new Assignments(this.getClients());
        try {
            assignmentsMap = brokers.generateAssignmentsForTransfer(1, 2, (Set)ImmutableSet.of((Object)"test"));
            assignments.reassign(assignmentsMap);
            this.ensureReassignmentComplete(assignments, assignmentsMap);
        }
        finally {
            assignmentsMap = brokers.generateAssignmentsForTransfer(2, 1, (Set)ImmutableSet.of((Object)"test"));
            assignments.reassign(assignmentsMap);
            this.ensureReassignmentComplete(assignments, assignmentsMap);
        }
    }

    protected void ensureReassignmentComplete(Assignments assignments, Map<String, Map<Integer, List<Integer>>> assignmentsMap) throws InterruptedException {
        System.out.println("\nassignments:");
        System.out.println(assignmentsMap);
        Map statusMap = assignments.verifyAssignment(assignmentsMap);
        while (statusMap.entrySet().stream().anyMatch(e -> ((Map)e.getValue()).entrySet().stream().anyMatch(e2 -> e2.getValue() == Assignments.Status.InProgress))) {
            Thread.sleep(10L);
            statusMap = assignments.verifyAssignment(assignmentsMap);
        }
        System.out.println("\nresult:");
        System.out.println(statusMap);
        if (statusMap.entrySet().stream().anyMatch(e -> ((Map)e.getValue()).entrySet().stream().anyMatch(e2 -> e2.getValue() == Assignments.Status.Failed))) {
            Assert.fail((String)"reassignment failed");
        }
    }
}

