/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.collection;

import java.util.ArrayList;

public class CascadedKeyValuePair<K, V>
implements Cloneable {
    private K[] _cascadedKeys;
    private V _value;

    @SafeVarargs
    public CascadedKeyValuePair(V value, K ... cascadedKeys) {
        this._cascadedKeys = cascadedKeys;
        this._value = value;
    }

    public K[] getCascadedKeys() {
        return this._cascadedKeys;
    }

    public V getValue() {
        return this._value;
    }

    public void setValue(V value) {
        this._value = value;
    }

    public String toString() {
        ArrayList<String> keyStrings = new ArrayList<String>();
        for (K k : this._cascadedKeys) {
            keyStrings.add(String.valueOf(k));
        }
        return String.format("%s { cascadedKeys: %s, value: %s }", this.getClass().getSimpleName(), keyStrings, this._value);
    }

    public CascadedKeyValuePair<K, V> clone() {
        try {
            return (CascadedKeyValuePair)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return new CascadedKeyValuePair<K, V>(this._value, this._cascadedKeys);
        }
    }
}

