/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.mydotey.collection.CascadedKeyValuePair;
import org.mydotey.collection.CascadedKeyValuePairNode;

public class CascadedKeyMap<K, V>
implements Iterable<CascadedKeyValuePair<K, V>> {
    private CascadedKeyValuePairNode<K, V> _rootNode = new CascadedKeyValuePairNode();
    private Function<K, CascadedKeyValuePairNode<K, V>> _nodeCreator = k -> new CascadedKeyValuePairNode(k);
    private Object _lock = new Object();
    private AtomicInteger _size = new AtomicInteger();

    public int size() {
        return this._size.get();
    }

    public boolean contains(K ... cascadedKeys) {
        return this.getNode(cascadedKeys) != null;
    }

    public V get(K ... cascadedKeys) {
        CascadedKeyValuePairNode<K, V> node;
        if (cascadedKeys == null || cascadedKeys.length == 0) {
            Objects.requireNonNull("cascadedKeys is null or empty");
        }
        if ((node = this.getNode(cascadedKeys)) == null) {
            return null;
        }
        CascadedKeyValuePair<K, V> pair = node.getPair();
        return pair == null ? null : (V)pair.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getOrAdd(Function<K[], V> valueFactory, K ... cascadedKeys) {
        V value;
        Objects.requireNonNull(valueFactory, "valueFactory is null");
        if (cascadedKeys == null || cascadedKeys.length == 0) {
            Objects.requireNonNull("cascadedKeys is null or empty");
        }
        if ((value = this.get(cascadedKeys)) != null) {
            return value;
        }
        Object object = this._lock;
        synchronized (object) {
            CascadedKeyValuePairNode<K, V> node = this.getOrAddNode(cascadedKeys);
            CascadedKeyValuePair<K, V> pair = node.getPair();
            if (pair != null) {
                return pair.getValue();
            }
            value = valueFactory.apply(cascadedKeys);
            if (value == null) {
                throw new IllegalArgumentException("valueFactory return null");
            }
            pair = new CascadedKeyValuePair<K, V>(value, cascadedKeys);
            node.setPair(pair);
            this._size.incrementAndGet();
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(V value, K ... cascadedKeys) {
        if (value == null) {
            return this.remove(cascadedKeys);
        }
        if (cascadedKeys == null || cascadedKeys.length == 0) {
            Objects.requireNonNull("cascadedKeys is null or empty");
        }
        Object object = this._lock;
        synchronized (object) {
            V oldValue;
            CascadedKeyValuePairNode<K, V> node = this.getOrAddNode(cascadedKeys);
            CascadedKeyValuePair<K, V> pair = node.getPair();
            V v = oldValue = pair == null ? null : (V)pair.getValue();
            if (pair == null) {
                pair = new CascadedKeyValuePair<K, V>(value, cascadedKeys);
                node.setPair(pair);
                this._size.incrementAndGet();
            } else {
                pair.setValue(value);
            }
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K ... cascadedKeys) {
        if (cascadedKeys == null || cascadedKeys.length == 0) {
            Objects.requireNonNull("cascadedKeys is null or empty");
        }
        Object object = this._lock;
        synchronized (object) {
            Stack<CascadedKeyValuePairNode> nodes = new Stack<CascadedKeyValuePairNode>();
            nodes.push(this._rootNode);
            CascadedKeyValuePairNode node = this._rootNode;
            int i = 0;
            for (K key : cascadedKeys) {
                if ((node = node.getChildren().get(key)) == null) break;
                nodes.push(node);
                ++i;
            }
            V value = null;
            if (i == cascadedKeys.length) {
                node = (CascadedKeyValuePairNode)nodes.pop();
                CascadedKeyValuePair pair = node.getPair();
                if (pair != null) {
                    value = pair.getValue();
                    this._size.decrementAndGet();
                }
                if (!node.getChildren().isEmpty()) {
                    node.setPair(null);
                    return value;
                }
                ((CascadedKeyValuePairNode)nodes.peek()).getChildren().remove(node.getKey());
            }
            node = (CascadedKeyValuePairNode)nodes.pop();
            while (node != this._rootNode) {
                if (node.getPair() == null && node.getChildren().isEmpty()) {
                    ((CascadedKeyValuePairNode)nodes.peek()).getChildren().remove(node.getKey());
                }
                node = (CascadedKeyValuePairNode)nodes.pop();
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this._lock;
        synchronized (object) {
            this._rootNode = new CascadedKeyValuePairNode();
            this._size.set(0);
        }
    }

    protected CascadedKeyValuePairNode<K, V> getNode(K ... cascadedKeys) {
        CascadedKeyValuePairNode<K, V> node = this._rootNode;
        for (K key : cascadedKeys) {
            if ((node = node.getChildren().get(key)) != null) continue;
            return null;
        }
        return node;
    }

    protected CascadedKeyValuePairNode<K, V> getOrAddNode(K ... cascadedKeys) {
        CascadedKeyValuePairNode<K, V> node = this._rootNode;
        for (K key : cascadedKeys) {
            node = node.getChildren().computeIfAbsent(key, this._nodeCreator);
        }
        return node;
    }

    @Override
    public Iterator<CascadedKeyValuePair<K, V>> iterator() {
        return this.toList().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CascadedKeyValuePair<K, V>> toList() {
        Object object = this._lock;
        synchronized (object) {
            ArrayList<CascadedKeyValuePair<K, V>> pairs = new ArrayList<CascadedKeyValuePair<K, V>>();
            this.fillList(pairs, this._rootNode);
            return pairs;
        }
    }

    private void fillList(List<CascadedKeyValuePair<K, V>> pairs, CascadedKeyValuePairNode<K, V> node) {
        if (node.getPair() != null) {
            pairs.add((CascadedKeyValuePair<K, V>)node.getPair().clone());
        }
        for (CascadedKeyValuePairNode<K, V> subNode : node.getChildren().values()) {
            this.fillList(pairs, subNode);
        }
    }

    public String toString() {
        List<CascadedKeyValuePair<K, V>> list = this.toList();
        return String.format("%s %s", this.getClass().getSimpleName(), list);
    }
}

