/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.spring.boot.open2internet.rsocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketConnector;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import io.rsocket.util.DefaultPayload;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mvnsearch.spring.boot.open2internet.JsonSupport;
import org.mvnsearch.spring.boot.open2internet.http.HttpRequest;
import org.mvnsearch.spring.boot.open2internet.http.LocalHttpServiceClient;
import org.mvnsearch.spring.boot.open2internet.rsocket.ConnectInfo;
import org.mvnsearch.spring.boot.open2internet.rsocket.Open2InternetAuthentication;
import org.mvnsearch.spring.boot.open2internet.rsocket.RSocketConnectionManager;
import reactor.core.publisher.Mono;

public class RSocketConnectionManagerImpl
extends JsonSupport
implements RSocketConnectionManager {
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_RESET = "\u001b[0m";
    private final Open2InternetAuthentication authentication;
    private final String[] upstreamRsocketUris;
    private final List<RSocket> rsockets = new ArrayList<RSocket>();
    private final List<ConnectInfo> connectInfoList = new ArrayList<ConnectInfo>();
    private final LocalHttpServiceClient localHttpServiceClient;

    public RSocketConnectionManagerImpl(ObjectMapper objectMapper, String[] upstreamRsocketUris, Open2InternetAuthentication authentication, LocalHttpServiceClient localHttpServiceClient) {
        super(objectMapper);
        this.upstreamRsocketUris = upstreamRsocketUris;
        this.authentication = authentication;
        this.localHttpServiceClient = localHttpServiceClient;
    }

    @Override
    public void connect() {
        if (!this.rsockets.isEmpty()) {
            return;
        }
        for (String upstreamRsocketUri : this.upstreamRsocketUris) {
            URI serverUri = URI.create(upstreamRsocketUri);
            RSocket rsocket = (RSocket)RSocketConnector.create().setupPayload(DefaultPayload.create((CharSequence)this.authentication.toString())).acceptor((connectionSetupPayload, rSocket) -> Mono.just((Object)new RSocket(){

                public Mono<Payload> requestResponse(Payload payload) {
                    try {
                        HttpRequest httpRequest = (HttpRequest)RSocketConnectionManagerImpl.this.readValue(payload.getData(), HttpRequest.class);
                        return RSocketConnectionManagerImpl.this.localHttpServiceClient.getHttpResponse(httpRequest).map(httpResponse -> DefaultPayload.create((CharSequence)RSocketConnectionManagerImpl.this.toJson(httpResponse)));
                    }
                    catch (Exception e) {
                        return Mono.just((Object)DefaultPayload.create((CharSequence)RSocketConnectionManagerImpl.this.toJson(e)));
                    }
                }

                public Mono<Void> fireAndForget(Payload payload) {
                    this.displayInfo(payload.getData());
                    return Mono.empty();
                }

                public Mono<Void> metadataPush(Payload payload) {
                    this.displayInfo(payload.getMetadata());
                    return Mono.empty();
                }

                private void displayInfo(ByteBuffer jsonData) {
                    try {
                        Map info = (Map)RSocketConnectionManagerImpl.this.readValue(jsonData, HashMap.class);
                        if ("app.exposed".equals(info.get("eventType"))) {
                            ConnectInfo connectInfo = new ConnectInfo();
                            connectInfo.setInternetUri((String)info.get("uri"));
                            connectInfo.setLocalBaseWebUri(RSocketConnectionManagerImpl.this.localHttpServiceClient.getLocalBaseWebUri());
                            connectInfo.setAccessToken((String)info.get("token"));
                            connectInfo.setQrCodeUri("https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=" + URLEncoder.encode(connectInfo.getInternetUri(), "utf-8"));
                            RSocketConnectionManagerImpl.this.outputAsGreen(connectInfo.hint());
                            RSocketConnectionManagerImpl.this.connectInfoList.add(connectInfo);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            })).connect((ClientTransport)TcpClientTransport.create((String)serverUri.getHost(), (int)serverUri.getPort())).block();
            this.rsockets.add(rsocket);
        }
    }

    @Override
    public void disConnect() {
        for (RSocket rsocket : this.rsockets) {
            try {
                rsocket.dispose();
            }
            catch (Exception exception) {}
        }
        this.connectInfoList.clear();
        this.outputAsGreen("Disconnected from Open2Internet.");
    }

    @Override
    public boolean isConnected() {
        return !this.rsockets.isEmpty();
    }

    @Override
    public List<ConnectInfo> getConnectInfo() {
        return this.connectInfoList;
    }

    private void outputAsGreen(String text) {
        System.out.println(ANSI_GREEN + text + ANSI_RESET);
    }
}

