/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.spring.boot.open2internet;

import java.util.HashMap;
import org.mvnsearch.spring.boot.open2internet.Open2InternetProperties;
import org.mvnsearch.spring.boot.open2internet.http.LocalHttpServiceClient;
import org.mvnsearch.spring.boot.open2internet.rsocket.RSocketConnectionManager;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;

@Endpoint(id="open2internet")
public class Open2InternetEndpoint {
    Open2InternetProperties properties;
    LocalHttpServiceClient localHttpServiceClient;
    RSocketConnectionManager rsocketConnectionManager;

    public void setProperties(Open2InternetProperties properties) {
        this.properties = properties;
    }

    public void setLocalHttpServiceClient(LocalHttpServiceClient localHttpServiceClient) {
        this.localHttpServiceClient = localHttpServiceClient;
    }

    public void setRsocketConnectionManager(RSocketConnectionManager rsocketConnectionManager) {
        this.rsocketConnectionManager = rsocketConnectionManager;
    }

    @ReadOperation
    public Object info() {
        if (this.rsocketConnectionManager.isConnected()) {
            return this.rsocketConnectionManager.getConnectInfo();
        }
        HashMap<String, Boolean> info = new HashMap<String, Boolean>();
        info.put("connected", false);
        return info;
    }

    @WriteOperation
    public void update(@Selector String ops) {
        if ("connect".equals(ops)) {
            this.rsocketConnectionManager.connect();
        } else if ("disconnect".equals(ops)) {
            this.rsocketConnectionManager.disConnect();
        }
    }
}

