/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.spring.boot.open2internet;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.mvnsearch.spring.boot.open2internet.http.HttpResponse;

public class JsonSupport {
    private ObjectMapper objectMapper;

    public JsonSupport(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected String toJson(HttpResponse httpResponse) {
        try {
            return this.objectMapper.writeValueAsString((Object)httpResponse);
        }
        catch (Exception e) {
            return "{}";
        }
    }

    protected String toJson(Exception e) {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatus(500);
        httpResponse.addHeader("Content-Type", "text/plain;charset=UTF-8");
        httpResponse.setBody(e.getMessage().getBytes());
        return this.toJson(httpResponse);
    }

    protected <T> T readValue(ByteBuffer data, Class<T> valueType) throws Exception {
        return (T)this.objectMapper.readValue((InputStream)new ByteBufferBackedInputStream(data), valueType);
    }
}

